/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.hdf5;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.hdf5.h5ar.ArchivingStrategy;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiverFactory;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5Archiver;
import ch.systemsx.cisd.hdf5.h5ar.NewArchiveEntry;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerWriter;
import java.io.File;
import java.io.InputStream;

class HDF5ContainerWriter
implements IHDF5ContainerWriter {
    private static final ArchivingStrategy COMPRESSED_STRATEGY = new ArchivingStrategy().compressAll().seal();
    private final IHDF5Archiver archiver;
    private final boolean compress;
    private final ArchivingStrategy strategy;

    HDF5ContainerWriter(HDF5Container parent, File containerFile, boolean compress) {
        this.archiver = HDF5ArchiverFactory.open((File)containerFile);
        this.compress = compress;
        this.strategy = compress ? COMPRESSED_STRATEGY : ArchivingStrategy.DEFAULT;
    }

    @Override
    public void archiveToHDF5Container(String rootPath, File path) throws IOExceptionUnchecked {
        if (path.isFile()) {
            this.archiver.archiveFromFilesystem(rootPath, path, this.strategy);
        } else {
            this.archiver.archiveFromFilesystemBelowDirectory(rootPath, path, this.strategy);
        }
    }

    @Override
    public void writeToHDF5Container(String objectPath, InputStream istream, long size) throws IOExceptionUnchecked {
        this.archiver.archiveFile(NewArchiveEntry.file((String)objectPath).compress(this.compress), istream);
    }

    @Override
    public void close() {
        this.archiver.close();
    }
}

