/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FilteredHierarchicalContent
implements IHierarchicalContent {
    private final IHierarchicalContent content;
    private final IHierarchicalContentNodeFilter filter;

    public FilteredHierarchicalContent(IHierarchicalContent content, IHierarchicalContentNodeFilter filter) {
        this.content = content;
        this.filter = filter;
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        return this.wrap(this.content.getRootNode());
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) throws IllegalArgumentException {
        return this.wrap(this.content.getNode(relativePath));
    }

    @Override
    public IHierarchicalContentNode tryGetNode(String relativePath) {
        return this.wrap(this.content.tryGetNode(relativePath));
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        return this.wrap(this.content.listMatchingNodes(relativePathPattern));
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        return this.wrap(this.content.listMatchingNodes(startingPath, fileNamePattern));
    }

    @Override
    public void close() {
        this.content.close();
    }

    private List<IHierarchicalContentNode> wrap(List<IHierarchicalContentNode> nodes) {
        ArrayList<IHierarchicalContentNode> wrappedNodes = new ArrayList<IHierarchicalContentNode>(nodes.size());
        for (IHierarchicalContentNode node : nodes) {
            if (!this.filter.accept(node)) continue;
            wrappedNodes.add(this.wrap(node));
        }
        return wrappedNodes;
    }

    private IHierarchicalContentNode wrap(IHierarchicalContentNode node) {
        return node == null ? null : new FilteredHierarchicalContentNode(node);
    }

    private final class FilteredHierarchicalContentNode
    implements IHierarchicalContentNode {
        private final IHierarchicalContentNode node;

        FilteredHierarchicalContentNode(IHierarchicalContentNode node) {
            this.node = node;
        }

        @Override
        public String getName() {
            return this.node.getName();
        }

        @Override
        public String getRelativePath() {
            return this.node.getRelativePath();
        }

        @Override
        public String getParentRelativePath() {
            return this.node.getParentRelativePath();
        }

        @Override
        public boolean exists() {
            return this.node.exists();
        }

        @Override
        public boolean isDirectory() {
            return this.node.isDirectory();
        }

        @Override
        public long getLastModified() {
            return this.node.getLastModified();
        }

        @Override
        public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
            return FilteredHierarchicalContent.this.wrap(this.node.getChildNodes());
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            return this.node.getFile();
        }

        @Override
        public File tryGetFile() {
            return this.node.tryGetFile();
        }

        @Override
        public long getFileLength() throws UnsupportedOperationException {
            return this.node.getFileLength();
        }

        @Override
        public int getChecksumCRC32() throws UnsupportedOperationException {
            return this.node.getChecksumCRC32();
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return this.node.isChecksumCRC32Precalculated();
        }

        @Override
        public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
            return this.node.getFileContent();
        }

        @Override
        public InputStream getInputStream() throws UnsupportedOperationException, IOExceptionUnchecked {
            return this.node.getInputStream();
        }
    }
}

