/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class VirtualHierarchicalContent
implements IHierarchicalContent {
    static final IVirtualNodeMergerFactory DEFAULT_MERGER_FACTORY = new IVirtualNodeMergerFactory(){

        @Override
        public IVirtualNodeMerger createNodeMerger() {
            return new VirtualNodeMerger(this);
        }

        @Override
        public IVirtualNodeListMerger createNodeListMerger() {
            return new VirtualNodeListMerger(this);
        }
    };
    private final IVirtualNodeMergerFactory mergerFactory;
    private final List<IHierarchicalContent> components;
    private IHierarchicalContentNode rootNode;

    VirtualHierarchicalContent(IVirtualNodeMergerFactory mergerFactory, List<IHierarchicalContent> components) {
        if (components == null || components.isEmpty()) {
            throw new IllegalArgumentException("Undefined contents");
        }
        this.components = components;
        this.mergerFactory = mergerFactory;
    }

    public VirtualHierarchicalContent(List<IHierarchicalContent> components) {
        this(DEFAULT_MERGER_FACTORY, components);
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.tryMergeNodes(new INodeProvider(){

                @Override
                public IHierarchicalContentNode tryGetNode(IHierarchicalContent content) {
                    return content.getRootNode();
                }
            });
        }
        return this.rootNode;
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) throws IllegalArgumentException {
        IHierarchicalContentNode nodeOrNull = this.tryGetNode(relativePath);
        if (nodeOrNull == null) {
            throw new IllegalArgumentException("Resource '" + relativePath + "' doesn't exist.");
        }
        return nodeOrNull;
    }

    @Override
    public IHierarchicalContentNode tryGetNode(final String relativePath) {
        return this.tryMergeNodes(new INodeProvider(){

            @Override
            public IHierarchicalContentNode tryGetNode(IHierarchicalContent content) {
                return content.tryGetNode(relativePath);
            }
        });
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(final String relativePathPattern) {
        return this.mergeNodeLists(new INodeListProvider(){

            @Override
            public List<IHierarchicalContentNode> getNodeList(IHierarchicalContent content) {
                return content.listMatchingNodes(relativePathPattern);
            }
        });
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(final String startingPath, final String fileNamePattern) {
        return this.mergeNodeLists(new INodeListProvider(){

            @Override
            public List<IHierarchicalContentNode> getNodeList(IHierarchicalContent content) {
                return content.listMatchingNodes(startingPath, fileNamePattern);
            }
        });
    }

    @Override
    public void close() {
        for (IHierarchicalContent component : this.components) {
            component.close();
        }
    }

    public String toString() {
        return "VirtualHierarchicalContent [components=" + Arrays.toString(this.components.toArray(new IHierarchicalContent[0])) + "]";
    }

    public int hashCode() {
        int result = 1;
        for (IHierarchicalContent component : this.components) {
            result = 31 * result + component.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualHierarchicalContent)) {
            return false;
        }
        VirtualHierarchicalContent other = (VirtualHierarchicalContent)obj;
        return this.components.equals(other.components);
    }

    private IHierarchicalContentNode tryMergeNodes(INodeProvider provider) {
        IVirtualNodeMerger merger = this.mergerFactory.createNodeMerger();
        for (IHierarchicalContent component : this.components) {
            IHierarchicalContentNode componentNode = provider.tryGetNode(component);
            if (componentNode == null) continue;
            merger.addNode(componentNode);
        }
        return merger.tryCreateMergedNode();
    }

    private List<IHierarchicalContentNode> mergeNodeLists(INodeListProvider listProvider) {
        IVirtualNodeListMerger listMerger = this.mergerFactory.createNodeListMerger();
        for (IHierarchicalContent component : this.components) {
            List<IHierarchicalContentNode> componentNodes = listProvider.getNodeList(component);
            listMerger.addNodes(componentNodes);
        }
        return listMerger.createMergedNodeList();
    }

    private static interface INodeListProvider {
        public List<IHierarchicalContentNode> getNodeList(IHierarchicalContent var1);
    }

    private static interface INodeProvider {
        public IHierarchicalContentNode tryGetNode(IHierarchicalContent var1);
    }

    static interface IVirtualNodeListMerger {
        public void addNodes(List<IHierarchicalContentNode> var1);

        public List<IHierarchicalContentNode> createMergedNodeList();
    }

    static interface IVirtualNodeMerger {
        public void addNode(IHierarchicalContentNode var1);

        public IHierarchicalContentNode tryCreateMergedNode();
    }

    static interface IVirtualNodeMergerFactory {
        public IVirtualNodeMerger createNodeMerger();

        public IVirtualNodeListMerger createNodeListMerger();
    }

    static class VirtualNode
    implements IHierarchicalContentNode {
        private final IVirtualNodeMergerFactory nodeMergerFactory;
        private final List<IHierarchicalContentNode> nodes;

        public VirtualNode(IVirtualNodeMergerFactory factory, List<IHierarchicalContentNode> nodes) {
            assert (nodes != null) : "Undefined nodes.";
            if (nodes.isEmpty()) {
                throw new IllegalArgumentException("Resource doesn't exist.");
            }
            this.nodeMergerFactory = factory;
            this.nodes = nodes;
        }

        private IHierarchicalContentNode lastNode() {
            return this.nodes.get(0);
        }

        private IHierarchicalContentNode lastExistingNode() {
            for (IHierarchicalContentNode node : this.nodes) {
                if (!node.exists()) continue;
                return node;
            }
            throw new IllegalStateException("Resource is currently unavailable. It might be in an archive.");
        }

        @Override
        public String getName() {
            return this.lastNode().getName();
        }

        @Override
        public String getRelativePath() {
            return this.lastNode().getRelativePath();
        }

        @Override
        public String getParentRelativePath() {
            return this.lastNode().getParentRelativePath();
        }

        @Override
        public boolean exists() {
            for (IHierarchicalContentNode node : this.nodes) {
                if (!node.exists()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDirectory() {
            return this.lastNode().isDirectory();
        }

        @Override
        public long getLastModified() {
            return this.lastNode().getLastModified();
        }

        @Override
        public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
            IVirtualNodeListMerger listMerger = this.nodeMergerFactory.createNodeListMerger();
            int i = this.nodes.size() - 1;
            while (i >= 0) {
                listMerger.addNodes(this.nodes.get(i).getChildNodes());
                --i;
            }
            return listMerger.createMergedNodeList();
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            return this.lastExistingNode().getFile();
        }

        @Override
        public File tryGetFile() {
            return this.lastExistingNode().tryGetFile();
        }

        @Override
        public long getFileLength() throws UnsupportedOperationException {
            if (this.isDirectory()) {
                long estimatedLength = 0L;
                for (IHierarchicalContentNode node : this.nodes) {
                    estimatedLength += node.getFileLength();
                }
                return estimatedLength;
            }
            return this.lastExistingNode().getFileLength();
        }

        @Override
        public int getChecksumCRC32() throws UnsupportedOperationException {
            return this.lastExistingNode().getChecksumCRC32();
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return this.lastExistingNode().isChecksumCRC32Precalculated();
        }

        @Override
        public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
            return this.lastExistingNode().getFileContent();
        }

        @Override
        public InputStream getInputStream() throws UnsupportedOperationException, IOExceptionUnchecked {
            return this.lastExistingNode().getInputStream();
        }

        public String toString() {
            return "VirtualNode [nodes=" + Arrays.toString(this.nodes.toArray(new IHierarchicalContentNode[0])) + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof VirtualNode)) {
                return false;
            }
            VirtualNode other = (VirtualNode)obj;
            return this.nodes.equals(other.nodes);
        }

        public int hashCode() {
            int result = 1;
            for (IHierarchicalContentNode node : this.nodes) {
                result = 31 * result + node.hashCode();
            }
            return result;
        }
    }

    static class VirtualNodeListMerger
    implements IVirtualNodeListMerger {
        private final IVirtualNodeMergerFactory nodeMergerFactory;
        private final Map<String, IVirtualNodeMerger> mergers = new LinkedHashMap<String, IVirtualNodeMerger>();

        public VirtualNodeListMerger(IVirtualNodeMergerFactory nodeMergerFactory) {
            this.nodeMergerFactory = nodeMergerFactory;
        }

        @Override
        public void addNodes(List<IHierarchicalContentNode> nodes) {
            for (IHierarchicalContentNode node : nodes) {
                String relativePath = node.getRelativePath();
                IVirtualNodeMerger merger = this.mergers.get(relativePath);
                if (merger == null) {
                    merger = this.nodeMergerFactory.createNodeMerger();
                    this.mergers.put(relativePath, merger);
                }
                merger.addNode(node);
            }
        }

        @Override
        public List<IHierarchicalContentNode> createMergedNodeList() {
            ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
            for (IVirtualNodeMerger merger : this.mergers.values()) {
                IHierarchicalContentNode nodeOrNull = merger.tryCreateMergedNode();
                if (nodeOrNull == null) continue;
                result.add(nodeOrNull);
            }
            return result;
        }
    }

    static class VirtualNodeMerger
    implements IVirtualNodeMerger {
        private final IVirtualNodeMergerFactory factory;
        private final LinkedList<IHierarchicalContentNode> nodes = new LinkedList();

        public VirtualNodeMerger(IVirtualNodeMergerFactory factory) {
            this.factory = factory;
        }

        @Override
        public void addNode(IHierarchicalContentNode node) {
            this.nodes.addFirst(node);
        }

        @Override
        public IHierarchicalContentNode tryCreateMergedNode() {
            if (this.nodes.isEmpty()) {
                return null;
            }
            return new VirtualNode(this.factory, this.nodes);
        }
    }
}

