/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.verifier;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IArchiveFileVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import de.schlichtherle.util.zip.ZipFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public abstract class AbstractZipFileVerifier
implements IArchiveFileVerifier {
    public abstract List<VerificationError> verify(ZipFile var1);

    @Override
    public final List<VerificationError> verify(File file) {
        ZipFile zip;
        ArrayList<VerificationError> errors = new ArrayList<VerificationError>();
        try {
            zip = new ZipFile(file);
        }
        catch (IOException ex) {
            errors.add(new VerificationError(VerificationErrorType.ERROR, "Reading zip file failed: " + ex.getMessage()));
            return errors;
        }
        return this.verify(zip);
    }

    protected long calculateCRC32(InputStream input) throws IOException {
        int len;
        BufferedInputStream inStream = new BufferedInputStream(input);
        int BLOCK_SIZE = 131072;
        byte[] buffer = new byte[BLOCK_SIZE];
        CRC32 crc32 = new CRC32();
        crc32.reset();
        while ((len = inStream.read(buffer, 0, BLOCK_SIZE)) > 0) {
            crc32.update(buffer, 0, len);
            buffer = new byte[BLOCK_SIZE];
        }
        return crc32.getValue();
    }
}

