/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.verifier;

import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.AbstractZipFileVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.CrcEnabled;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.IArchiveFileContent;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.IArchiveFileMetaDataRepository;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ZipFileHeaderVerifier
extends AbstractZipFileVerifier {
    private final IArchiveFileMetaDataRepository fileMetaDataRepository;
    private final CrcEnabled crcEnabled;

    public ZipFileHeaderVerifier(IArchiveFileMetaDataRepository fileMetaDataRepository, CrcEnabled crcEnabled) {
        this.fileMetaDataRepository = fileMetaDataRepository;
        this.crcEnabled = crcEnabled;
    }

    @Override
    public List<VerificationError> verify(ZipFile zip) {
        ArrayList<VerificationError> result = new ArrayList<VerificationError>();
        String filename = zip.getName();
        String dataSetCode = filename.substring(filename.lastIndexOf("/") + 1, filename.lastIndexOf("."));
        String repositoryName = this.fileMetaDataRepository.getDescription();
        IArchiveFileContent metaData = this.fileMetaDataRepository.getMetaData(dataSetCode);
        if (metaData == null) {
            result.add(new VerificationError(VerificationErrorType.WARNING, "Could not find entry for dataset in " + repositoryName));
            return result;
        }
        Enumeration entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || entryName.equals("meta-data.tsv")) continue;
            Long externalSize = metaData.getFileSize(entryName);
            if (externalSize == null) {
                result.add(new VerificationError(VerificationErrorType.ERROR, "Could not find entry for file " + entryName + " in " + repositoryName));
                continue;
            }
            if (entry.getSize() != externalSize.longValue()) {
                result.add(new VerificationError(VerificationErrorType.ERROR, String.valueOf(entryName) + ": size in archive file: " + entry.getSize() + ", size in " + repositoryName + ": " + externalSize));
            }
            Long externalCrc = metaData.getFileCrc(entryName);
            if (CrcEnabled.TRUE.equals((Object)this.crcEnabled)) {
                if (externalCrc == null) {
                    result.add(new VerificationError(VerificationErrorType.ERROR, String.valueOf(entryName) + ": no CRC32 found in " + repositoryName));
                    continue;
                }
                if (externalCrc.longValue() == entry.getCrc()) continue;
                result.add(new VerificationError(VerificationErrorType.ERROR, String.valueOf(entryName) + ": CRC32 in archive file: " + IOUtilities.crc32ToString((int)entry.getCrc()) + ", CRC32 in " + repositoryName + ": " + IOUtilities.crc32ToString((int)externalCrc.longValue())));
                continue;
            }
            if (externalCrc == null) continue;
            result.add(new VerificationError(VerificationErrorType.ERROR, String.valueOf(entryName) + ": CRC32 found in " + repositoryName + " even it should be disabled. Value was " + IOUtilities.crc32ToString((int)externalCrc.longValue())));
        }
        return result;
    }
}

