/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.verifier;

import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.AbstractZipFileVerifier;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipException;

public class ZipFileIntegrityVerifier
extends AbstractZipFileVerifier {
    @Override
    public List<VerificationError> verify(ZipFile zip) {
        ArrayList<VerificationError> errors = new ArrayList<VerificationError>();
        Enumeration entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            VerificationError error = this.checkZipEntry(zip, entry);
            if (error == null) continue;
            errors.add(error);
        }
        return errors;
    }

    /*
     * Loose catch block
     */
    private VerificationError checkZipEntry(ZipFile zip, ZipEntry entry) {
        InputStream input;
        block18: {
            VerificationError verificationError;
            block19: {
                input = null;
                input = zip.getInputStream(entry);
                long crc = this.calculateCRC32(input);
                if (crc == entry.getCrc()) break block18;
                verificationError = new VerificationError(VerificationErrorType.ERROR, String.valueOf(entry.getName()) + ": CRC failure (calculated: " + IOUtilities.crc32ToString((int)crc) + ", zip file header: " + IOUtilities.crc32ToString((int)entry.getCrc()) + ")");
                if (input == null) break block19;
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            return verificationError;
            catch (ZipException ex) {
                VerificationError verificationError2;
                block20: {
                    verificationError2 = new VerificationError(VerificationErrorType.ERROR, "Corrupted zip file entry, reason: " + ex.getMessage());
                    if (input == null) break block20;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                return verificationError2;
            }
            catch (IOException ex2) {
                VerificationError verificationError3;
                block21: {
                    verificationError3 = new VerificationError(VerificationErrorType.ERROR, String.valueOf(entry.getName()) + ": " + ex2.getMessage());
                    if (input == null) break block21;
                    {
                        catch (Throwable throwable) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                return verificationError3;
            }
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

