/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.admin;

import ch.systemsx.cisd.openbis.dss.client.admin.AbstractCommand;
import ch.systemsx.cisd.openbis.dss.client.admin.CommonArguments;
import ch.systemsx.cisd.openbis.dss.generic.server.DirectoryRendererUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.ShareInfo;
import java.util.List;

public class ListSharesCommand
extends AbstractCommand {
    private ListSharesCommandArguments arguments = new ListSharesCommandArguments();

    ListSharesCommand() {
        super("list-shares");
    }

    @Override
    protected ListSharesCommandArguments getArguments() {
        return this.arguments;
    }

    @Override
    protected String getRequiredArgumentsString() {
        return "";
    }

    @Override
    void execute() {
        List<ShareInfo> shares = this.service.listAllShares(this.sessionToken);
        if (shares.isEmpty()) {
            System.out.println("No shares!");
        }
        System.out.println(String.valueOf(shares.size()) + " shares:");
        for (ShareInfo shareInfo : shares) {
            StringBuilder builder = new StringBuilder();
            builder.append(shareInfo.getShareId()).append(": ");
            builder.append(DirectoryRendererUtil.renderFileSize(shareInfo.getFreeSpace()));
            builder.append(" bytes free.");
            if (shareInfo.isIncoming()) {
                builder.append(" Incoming share.");
            }
            if (shareInfo.isWithdrawShare()) {
                builder.append(" Data sets should be with drawn.");
            }
            if (shareInfo.isIgnoredForShuffling()) {
                builder.append(" To be ignored in shuffling.");
            }
            System.out.println(builder.toString());
        }
    }

    static final class ListSharesCommandArguments
    extends CommonArguments {
        ListSharesCommandArguments() {
        }
    }
}

