/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.admin;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.admin.AbstractCommand;
import ch.systemsx.cisd.openbis.dss.client.admin.ListSharesCommand;
import ch.systemsx.cisd.openbis.dss.client.admin.MoveDataSetsCommand;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.helpers.LogLog;

public class ShareManagerApplication {
    private final Map<String, AbstractCommand> commandMap = new HashMap<String, AbstractCommand>();

    ShareManagerApplication(AbstractCommand ... commands) {
        AbstractCommand[] abstractCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractCommand command = abstractCommandArray[n2];
            this.commandMap.put(command.getName(), command);
            ++n2;
        }
    }

    void parseAndRun(String ... args) {
        if (args.length == 0) {
            throw new UserFailureException("No command specified. Allowed commands are " + this.commandMap.keySet() + ".");
        }
        String commandName = args[0];
        AbstractCommand command = this.commandMap.get(commandName);
        if (command == null) {
            throw new UserFailureException("Unknown command '" + commandName + "'. Allowed commands are " + this.commandMap.keySet() + ".");
        }
        String[] reducedArgs = new String[args.length - 1];
        System.arraycopy(args, 1, reducedArgs, 0, reducedArgs.length);
        command.parseArguments(reducedArgs);
        command.login();
        command.execute();
    }

    public static void main(String[] args) {
        LogLog.setQuietMode((boolean)true);
        ShareManagerApplication application = new ShareManagerApplication(new ListSharesCommand(), new MoveDataSetsCommand());
        try {
            application.parseAndRun(args);
        }
        catch (UserFailureException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.exit(1);
        }
    }
}

