/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageChecklist;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageSeriesPoint;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateDimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HCSImageCheckList
extends AbstractImageChecklist {
    private final Map<FullLocation, Check> imageMap;
    private final HashMap<FullLocationImageSeriesPoint, DuplicateLocationImages> duplicateLocationImages;

    public HCSImageCheckList(List<String> channelCodes, PlateDimension plateGeometry, Geometry wellGeometry) {
        if (channelCodes.size() < 1) {
            throw new IllegalArgumentException("No channels defined!");
        }
        if (plateGeometry == null) {
            throw new IllegalArgumentException("Unspecified plate geometry.");
        }
        if (wellGeometry == null) {
            throw new IllegalArgumentException("Unspecified well geometry.");
        }
        this.imageMap = new HashMap<FullLocation, Check>();
        this.duplicateLocationImages = new HashMap();
        for (String channelCode : channelCodes) {
            int wellCol = 1;
            while (wellCol <= plateGeometry.getColsNum()) {
                int wellRow = 1;
                while (wellRow <= plateGeometry.getRowsNum()) {
                    int tileCol = 1;
                    while (tileCol <= wellGeometry.getColumns()) {
                        int tileRow = 1;
                        while (tileRow <= wellGeometry.getRows()) {
                            this.imageMap.put(new FullLocation(wellRow, wellCol, tileRow, tileCol, channelCode), new Check());
                            ++tileRow;
                        }
                        ++tileCol;
                    }
                    ++wellRow;
                }
                ++wellCol;
            }
        }
        assert (this.imageMap.size() == channelCodes.size() * plateGeometry.getColsNum() * plateGeometry.getRowsNum() * wellGeometry.getColumns() * wellGeometry.getRows()) : "Wrong map size";
    }

    @Override
    public final void checkOff(AcquiredSingleImage image) {
        Integer seriesNumberOrNull;
        Float depthOrNull;
        assert (image != null) : "Unspecified image.";
        FullLocation location = HCSImageCheckList.createLocation(image);
        Check check = this.imageMap.get(location);
        if (check == null) {
            throw new IllegalArgumentException("Invalid channel/well/tile: " + image);
        }
        Float timepointOrNull = image.tryGetTimePoint();
        if (check.isCheckedOff(timepointOrNull, depthOrNull = image.tryGetDepth(), seriesNumberOrNull = image.tryGetSeriesNumber())) {
            FullLocationImageSeriesPoint fullLocationImageSeriesPoint = new FullLocationImageSeriesPoint(location, new ImageSeriesPoint(timepointOrNull, depthOrNull, seriesNumberOrNull));
            DuplicateLocationImages duplicates = this.duplicateLocationImages.get(fullLocationImageSeriesPoint);
            if (duplicates == null) {
                AcquiredSingleImage primaryImage = check.getImageForLocation(timepointOrNull, depthOrNull, seriesNumberOrNull);
                duplicates = new DuplicateLocationImages(fullLocationImageSeriesPoint, primaryImage);
                this.duplicateLocationImages.put(fullLocationImageSeriesPoint, duplicates);
            }
            duplicates.addDuplicateLocationImage(image);
        } else {
            check.checkOff(timepointOrNull, depthOrNull, seriesNumberOrNull, image);
        }
    }

    @Override
    public void checkForDuplicates() throws IllegalArgumentException {
        if (this.duplicateLocationImages.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Only one image may represent a location for a depth/time/series point. The following ambiguities were found:\n");
        Object[] locations = this.duplicateLocationImages.keySet().toArray(new FullLocationImageSeriesPoint[0]);
        Arrays.sort(locations);
        Object[] objectArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            Object location = objectArray[n2];
            DuplicateLocationImages duplicateImage = this.duplicateLocationImages.get(location);
            sb.append(duplicateImage.errorString());
            sb.append("\n");
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        throw new IllegalArgumentException(sb.toString());
    }

    private static FullLocation createLocation(AcquiredSingleImage image) {
        return new FullLocation(image.getWellRow(), image.getWellColumn(), image.getTileRow(), image.getTileColumn(), image.getChannelCode());
    }

    public final List<FullLocation> getCheckedOnFullLocations() {
        ArrayList<FullLocation> fullLocations = new ArrayList<FullLocation>();
        for (Map.Entry<FullLocation, Check> entry : this.imageMap.entrySet()) {
            if (entry.getValue().isCheckedOff(null, null, null)) continue;
            fullLocations.add(entry.getKey());
        }
        return fullLocations;
    }

    @Override
    public int getCheckedOnFullLocationsSize() {
        return this.getCheckedOnFullLocations().size();
    }

    @Override
    public String getIncompleteDataSetErrorMessage(String dataSetFileName) {
        List<FullLocation> fullLocations = this.getCheckedOnFullLocations();
        return String.format("Incomplete data set '%s': %d image file(s) are missing (locations: %s)", dataSetFileName, fullLocations.size(), CollectionUtils.abbreviate(fullLocations, 10));
    }

    private static final class Check {
        private boolean checkedOff = false;
        private final Set<ImageSeriesPoint> dimensions = new HashSet<ImageSeriesPoint>();
        private final HashMap<ImageSeriesPoint, AcquiredSingleImage> seriesImageMap = new HashMap();

        private Check() {
        }

        final void checkOff(Float timepointOrNull, Float depthOrNull, Integer seriesNumberOrNull, AcquiredSingleImage image) {
            ImageSeriesPoint seriesPoint = new ImageSeriesPoint(timepointOrNull, depthOrNull, seriesNumberOrNull);
            this.dimensions.add(seriesPoint);
            this.seriesImageMap.put(seriesPoint, image);
            this.checkedOff = true;
        }

        final boolean isCheckedOff(Float timepointOrNull, Float depthOrNull, Integer seriesNumberOrNull) {
            ImageSeriesPoint dim = null;
            if (timepointOrNull != null || depthOrNull != null || seriesNumberOrNull != null) {
                dim = new ImageSeriesPoint(timepointOrNull, depthOrNull, seriesNumberOrNull);
            }
            return this.checkedOff && (dim == null || this.dimensions.contains(dim));
        }

        final AcquiredSingleImage getImageForLocation(Float timepointOrNull, Float depthOrNull, Integer seriesNumberOrNull) {
            ImageSeriesPoint seriesPoint = new ImageSeriesPoint(timepointOrNull, depthOrNull, seriesNumberOrNull);
            return this.seriesImageMap.get(seriesPoint);
        }
    }

    private static class DuplicateLocationImages {
        private final FullLocationImageSeriesPoint location;
        private final AcquiredSingleImage primaryImage;
        private final ArrayList<AcquiredSingleImage> duplicateImages;

        public DuplicateLocationImages(FullLocationImageSeriesPoint location, AcquiredSingleImage primaryImage) {
            this.location = location;
            this.primaryImage = primaryImage;
            this.duplicateImages = new ArrayList();
        }

        public void addDuplicateLocationImage(AcquiredSingleImage image) {
            this.duplicateImages.add(image);
        }

        public String errorString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Location: ");
            sb.append("Well[");
            sb.append(((FullLocationImageSeriesPoint)this.location).location.wellRow);
            sb.append(",");
            sb.append(((FullLocationImageSeriesPoint)this.location).location.wellCol);
            sb.append("]");
            sb.append(" Tile[");
            sb.append(((FullLocationImageSeriesPoint)this.location).location.tileRow);
            sb.append(",");
            sb.append(((FullLocationImageSeriesPoint)this.location).location.tileCol);
            sb.append("]");
            sb.append(" Channel[");
            sb.append(((FullLocationImageSeriesPoint)this.location).location.channelCode);
            sb.append("]");
            if (this.location.imageSeriesPoint.getDepth() != null) {
                sb.append(" Depth[");
                sb.append(this.location.imageSeriesPoint.getDepth());
                sb.append("]");
            }
            if (this.location.imageSeriesPoint.getTime() != null) {
                sb.append(" Time[");
                sb.append(this.location.imageSeriesPoint.getTime());
                sb.append("]");
            }
            if (this.location.imageSeriesPoint.getSeriesNumber() != null) {
                sb.append(" Series[");
                sb.append(this.location.imageSeriesPoint.getSeriesNumber());
                sb.append("]");
            }
            sb.append(" mapped to the following images:");
            sb.append("\n\t");
            sb.append(this.primaryImage.getImageReference().getImageRelativePath());
            for (AcquiredSingleImage duplicateImage : this.duplicateImages) {
                sb.append("\n\t");
                sb.append(duplicateImage.getImageReference().getImageRelativePath());
            }
            return sb.toString();
        }
    }

    public static final class FullLocation
    extends AbstractHashable
    implements Comparable<FullLocation> {
        final int wellRow;
        final int wellCol;
        final int tileRow;
        final int tileCol;
        final String channelCode;

        public FullLocation(int wellRow, int wellCol, int tileRow, int tileCol, String channelCode) {
            this.wellRow = wellRow;
            this.wellCol = wellCol;
            this.tileRow = tileRow;
            this.tileCol = tileCol;
            this.channelCode = channelCode.toUpperCase();
        }

        private static final String toString(int row, int col, String type) {
            return String.valueOf(type) + "=(" + row + "," + col + ")";
        }

        @Override
        public final String toString() {
            return "[channel=" + this.channelCode + ", " + FullLocation.toString(this.wellRow, this.wellCol, "well") + ", " + FullLocation.toString(this.tileRow, this.tileCol, "tile") + "]";
        }

        @Override
        public int compareTo(FullLocation o) {
            int wellRowCompare = new Integer(this.wellRow).compareTo(new Integer(o.wellRow));
            if (wellRowCompare != 0) {
                return wellRowCompare;
            }
            int wellColCompare = new Integer(this.wellCol).compareTo(new Integer(o.wellCol));
            if (wellColCompare != 0) {
                return wellColCompare;
            }
            int tileRowCompare = new Integer(this.tileRow).compareTo(new Integer(o.tileRow));
            if (tileRowCompare != 0) {
                return tileRowCompare;
            }
            return new Integer(this.tileCol).compareTo(new Integer(o.tileCol));
        }
    }

    private static class FullLocationImageSeriesPoint
    extends AbstractHashable
    implements Comparable<FullLocationImageSeriesPoint> {
        private final FullLocation location;
        private final ImageSeriesPoint imageSeriesPoint;

        public FullLocationImageSeriesPoint(FullLocation location, ImageSeriesPoint imageSeriesPoint) {
            this.location = location;
            this.imageSeriesPoint = imageSeriesPoint;
        }

        @Override
        public int compareTo(FullLocationImageSeriesPoint o) {
            int locationCompare = this.location.compareTo(o.location);
            if (locationCompare != 0) {
                return locationCompare;
            }
            return this.imageSeriesPoint.compareTo(o.imageSeriesPoint);
        }
    }
}

