/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageStorageProcessor;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.ImageFileExtractionResult;
import ch.systemsx.cisd.openbis.dss.etl.ImageValidator;
import ch.systemsx.cisd.openbis.dss.etl.MicroscopyImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.MicroscopyImageDatasetUploader;
import ch.systemsx.cisd.openbis.dss.etl.PlateStorageProcessor;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class MicroscopyStorageProcessor
extends AbstractImageStorageProcessor {
    public MicroscopyStorageProcessor(Properties properties) {
        super(properties);
    }

    @Override
    protected void storeInDatabase(IImagingQueryDAO dao, PlateStorageProcessor.ImageDatasetOwnerInformation dataSetInformation, ImageFileExtractionResult extractedImages, boolean thumbnailsOnly) {
        List<AcquiredSingleImage> images = extractedImages.getImages();
        MicroscopyImageDatasetInfo dataset = this.createMicroscopyImageDatasetInfo(dataSetInformation, images, extractedImages.getTileGeometry(), extractedImages.tryGetImageLibrary());
        MicroscopyImageDatasetUploader.upload(dao, dataset, images, extractedImages.getChannels());
    }

    private MicroscopyImageDatasetInfo createMicroscopyImageDatasetInfo(PlateStorageProcessor.ImageDatasetOwnerInformation dataSetInformation, List<AcquiredSingleImage> images, Geometry tileGeometry, ImageLibraryInfo imageLibraryInfoOrNull) {
        boolean hasImageSeries = MicroscopyStorageProcessor.hasImageSeries(images);
        ImageDatasetInfo imageDatasetInfo = new ImageDatasetInfo(tileGeometry.getRows(), tileGeometry.getColumns(), hasImageSeries, imageLibraryInfoOrNull, dataSetInformation.getImageZoomLevels());
        return new MicroscopyImageDatasetInfo(dataSetInformation.getDataSetCode(), imageDatasetInfo);
    }

    @Override
    protected boolean validateImages(PlateStorageProcessor.DatasetOwnerInformation dataSetInformation, IMailClient mailClient, File incomingDataSetDirectory, ImageFileExtractionResult extractionResult) {
        ImageValidator validator = new ImageValidator(dataSetInformation, mailClient, incomingDataSetDirectory, extractionResult, operationLog, notificationLog, false);
        validator.validateImages();
        return true;
    }
}

