/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.imagereaders.ImageID;
import java.io.Serializable;

public class ImageIdentifier
implements Comparable<ImageIdentifier>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ImageIdentifier NULL = new ImageIdentifier(0, 0, 0, 0);
    private final int seriesIndex;
    private final int timeSeriesIndex;
    private final int focalPlaneIndex;
    private final int colorChannelIndex;

    public ImageIdentifier(int seriesIndex, int timeSeriesIndex, int focalPlaneIndex, int colorChannelIndex) {
        this.seriesIndex = seriesIndex;
        this.timeSeriesIndex = timeSeriesIndex;
        this.focalPlaneIndex = focalPlaneIndex;
        this.colorChannelIndex = colorChannelIndex;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public int getTimeSeriesIndex() {
        return this.timeSeriesIndex;
    }

    public int getFocalPlaneIndex() {
        return this.focalPlaneIndex;
    }

    public int getColorChannelIndex() {
        return this.colorChannelIndex;
    }

    public String getUniqueStringIdentifier() {
        return new ImageID(this.getSeriesIndex(), this.getTimeSeriesIndex(), this.getFocalPlaneIndex(), this.getColorChannelIndex()).getID();
    }

    @Override
    public int compareTo(ImageIdentifier that) {
        int diff = this.seriesIndex - that.seriesIndex;
        if (diff != 0) {
            return diff;
        }
        diff = this.timeSeriesIndex - that.timeSeriesIndex;
        if (diff != 0) {
            return diff;
        }
        diff = this.focalPlaneIndex - that.focalPlaneIndex;
        if (diff != 0) {
            return diff;
        }
        return this.colorChannelIndex - that.colorChannelIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageIdentifier)) {
            return false;
        }
        ImageIdentifier that = (ImageIdentifier)obj;
        return this.seriesIndex == that.seriesIndex && this.timeSeriesIndex == that.timeSeriesIndex && this.focalPlaneIndex == that.focalPlaneIndex && this.colorChannelIndex == that.colorChannelIndex;
    }

    public int hashCode() {
        return ((this.seriesIndex * 37 + this.timeSeriesIndex) * 37 + this.focalPlaneIndex) * 37 + this.colorChannelIndex;
    }

    public String toString() {
        return String.valueOf(this.seriesIndex) + "." + this.timeSeriesIndex + "." + this.focalPlaneIndex + "." + this.colorChannelIndex;
    }
}

