/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.impl;

import ch.systemsx.cisd.openbis.dss.etl.dto.RelativeImageFile;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ToStringUtil;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ThumbnailsInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<RelativeImageFile, HashMap<ColorComponent, String>> imageToThumbnailPathMap = new HashMap<RelativeImageFile, HashMap<ColorComponent, String>>();
    private final Map<String, PhysicalDatasetInfo> datasetInfos = new HashMap<String, PhysicalDatasetInfo>();

    public void putDataSet(String permId, String rootPath, ThumbnailsStorageFormat.FileFormat fileFormat, Map<String, String> transformations) {
        this.datasetInfos.put(permId, new PhysicalDatasetInfo(rootPath, fileFormat, transformations));
    }

    public synchronized void saveThumbnailPath(String permId, RelativeImageFile image, ColorComponent colorComponentOrNull, String thumbnailRelativePath, int width, int height, int colorDepth) {
        HashMap<ColorComponent, String> imageComponents = this.imageToThumbnailPathMap.get(image);
        if (imageComponents == null) {
            imageComponents = new HashMap();
            this.imageToThumbnailPathMap.put(image, imageComponents);
        }
        imageComponents.put(colorComponentOrNull, thumbnailRelativePath);
        PhysicalDatasetInfo datasetInfo = this.datasetInfos.get(permId);
        if (datasetInfo != null) {
            datasetInfo.thumbnailsWidth = Math.max(datasetInfo.thumbnailsWidth, width);
            datasetInfo.thumbnailsHeight = Math.max(datasetInfo.thumbnailsHeight, height);
            datasetInfo.colorDepth = colorDepth;
        }
    }

    public synchronized String getThumbnailPath(RelativeImageFile image, ColorComponent colorComponentOrNull) {
        return this.imageToThumbnailPathMap.get(image).get((Object)colorComponentOrNull);
    }

    public Set<String> getThumbnailPhysicalDatasetsPermIds() {
        return this.datasetInfos.keySet();
    }

    public Size tryGetDimension(String permId) {
        PhysicalDatasetInfo datasetInfo = this.datasetInfos.get(permId);
        if (datasetInfo != null && datasetInfo.thumbnailsWidth > 0 && datasetInfo.thumbnailsHeight > 0) {
            return new Size(datasetInfo.thumbnailsWidth, datasetInfo.thumbnailsHeight);
        }
        return null;
    }

    public Integer tryGetColorDepth(String permId) {
        PhysicalDatasetInfo datasetInfo = this.datasetInfos.get(permId);
        if (datasetInfo != null) {
            return datasetInfo.colorDepth;
        }
        return null;
    }

    public ThumbnailsStorageFormat.FileFormat getFileType(String permId) {
        PhysicalDatasetInfo datasetInfo = this.datasetInfos.get(permId);
        if (datasetInfo != null) {
            return datasetInfo.fileType;
        }
        return null;
    }

    public Map<String, String> getTransformations(String permId) {
        PhysicalDatasetInfo datasetInfo = this.datasetInfos.get(permId);
        return datasetInfo != null ? datasetInfo.transformations : null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        ToStringUtil.appendNameAndObject(buffer, "number of thumbnails", this.imageToThumbnailPathMap.size());
        ToStringUtil.appendNameAndObject(buffer, "dataset perm ids: ", this.printPermIds());
        return buffer.toString();
    }

    private String printPermIds() {
        StringBuilder sb = new StringBuilder("[");
        boolean notFirst = false;
        for (String permId : this.datasetInfos.keySet()) {
            if (notFirst) {
                sb.append(";");
                notFirst = true;
            }
            sb.append(" ").append(permId);
        }
        return sb.append(" ]").toString();
    }

    public String getRootPath(String permId) {
        return this.datasetInfos.get(permId).rootPath;
    }

    public static class PhysicalDatasetInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String rootPath;
        private int thumbnailsWidth;
        private int thumbnailsHeight;
        private Integer colorDepth;
        private ThumbnailsStorageFormat.FileFormat fileType;
        private Map<String, String> transformations;

        public PhysicalDatasetInfo(String rootPath, ThumbnailsStorageFormat.FileFormat fileType, Map<String, String> transformations) {
            this.rootPath = rootPath;
            this.fileType = fileType;
            this.transformations = transformations;
        }
    }
}

