/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails.IThumbnailsConfiguration;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractThumbnailsConfiguration
implements IThumbnailsConfiguration {
    private String fileName;
    private String fileFormat;
    private Map<String, String> transformations = new HashMap<String, String>();

    @Override
    public ThumbnailsStorageFormat getThumbnailsStorageFormat(SimpleImageDataConfig config) {
        ThumbnailsStorageFormat thumbnailsStorageFormat = new ThumbnailsStorageFormat();
        thumbnailsStorageFormat.setAllowedMachineLoadDuringGeneration(config.getAllowedMachineLoadDuringThumbnailsGeneration());
        thumbnailsStorageFormat.setThumbnailsFileName(this.getFileName());
        thumbnailsStorageFormat.setMaxWidth(config.getMaxThumbnailWidthAndHeight());
        thumbnailsStorageFormat.setMaxHeight(config.getMaxThumbnailWidthAndHeight());
        thumbnailsStorageFormat.setGenerateWithImageMagic(config.getGenerateThumbnailsWithImageMagic());
        thumbnailsStorageFormat.setImageMagicParams(config.getThumbnailsGenerationImageMagicParams());
        thumbnailsStorageFormat.setHighQuality(config.getGenerateThumbnailsIn8BitHighQuality());
        this.setFileFormat(thumbnailsStorageFormat, config.getThumbnailsFileFormat());
        thumbnailsStorageFormat.setTransformations(this.transformations);
        return thumbnailsStorageFormat;
    }

    protected abstract String getDefaultFileName();

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return this.getDefaultFileName();
    }

    @Override
    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    private void setFileFormat(ThumbnailsStorageFormat thumbnailsStorageFormat, String defaultValue) {
        if (this.fileFormat != null) {
            thumbnailsStorageFormat.setFileFormat(this.fileFormat);
        } else if (defaultValue != null) {
            thumbnailsStorageFormat.setFileFormat(defaultValue);
        }
    }

    @Override
    public String setTransformation(String channelCode, String transformationCode) {
        return this.transformations.put(channelCode.toUpperCase(), transformationCode);
    }

    protected String getFirstTransformationCode() {
        if (this.transformations.size() == 0) {
            return "";
        }
        return "_" + this.transformations.values().iterator().next();
    }
}

