/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dynamix;

import ch.systemsx.cisd.common.parser.BeanProperty;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class WellLocationMappingUtils {
    WellLocationMappingUtils() {
    }

    public static Map<DynamixWellPosition, WellLocation> parseWellLocationMap(File mappingFile) {
        TabFileLoader<MappingEntry> parser = new TabFileLoader<MappingEntry>(MappingEntry.class);
        Map<String, String> defaults = Collections.emptyMap();
        List<MappingEntry> mappingEntries = parser.load(mappingFile, defaults);
        return WellLocationMappingUtils.createMapping(mappingEntries);
    }

    public static DynamixWellPosition parseWellPosition(String sideToken, String posToken) {
        return new DynamixWellPosition(new Integer(posToken), WellLocationMappingUtils.isRight(sideToken));
    }

    private static Map<DynamixWellPosition, WellLocation> createMapping(List<MappingEntry> mappingEntries) {
        HashMap<DynamixWellPosition, WellLocation> mapping = new HashMap<DynamixWellPosition, WellLocation>();
        for (MappingEntry entry : mappingEntries) {
            DynamixWellPosition wellPos = WellLocationMappingUtils.parseWellPosition(entry.getSide(), entry.getPosition());
            int row = new Integer(entry.getRow());
            int col = new Integer(entry.getColumn());
            WellLocation wellLoc = new WellLocation(row, col);
            mapping.put(wellPos, wellLoc);
        }
        return mapping;
    }

    private static boolean isRight(String sideToken) {
        return sideToken.equalsIgnoreCase("Right");
    }

    static class DynamixWellPosition
    extends AbstractHashable {
        private final int position;
        private final boolean isRight;

        public DynamixWellPosition(int position, boolean isRight) {
            this.position = position;
            this.isRight = isRight;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isRight() {
            return this.isRight;
        }
    }

    public static class MappingEntry
    extends AbstractHashable {
        private String position;
        private String side;
        private String row;
        private String column;

        public String getPosition() {
            return this.position;
        }

        @BeanProperty(label="position")
        public void setPosition(String position) {
            this.position = position;
        }

        public String getSide() {
            return this.side;
        }

        @BeanProperty(label="Side")
        public void setSide(String side) {
            this.side = side;
        }

        public String getRow() {
            return this.row;
        }

        @BeanProperty(label="row")
        public void setRow(String row) {
            this.row = row;
        }

        public String getColumn() {
            return this.column;
        }

        @BeanProperty(label="column")
        public void setColumn(String column) {
            this.column = column;
        }
    }
}

