/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.featurevector;

import ch.systemsx.cisd.openbis.dss.etl.HCSContainerDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.ImagingDatabaseHelper;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CanonicalFeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAnalysisDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureValuesDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureVocabularyTermDTO;
import java.util.List;

public class FeatureVectorUploader {
    private final IImagingQueryDAO dao;
    private final HCSContainerDatasetInfo info;
    private final String dataSetPermID;

    public FeatureVectorUploader(IImagingQueryDAO imagingDao, HCSContainerDatasetInfo info) {
        this(imagingDao, info, info.getDatasetPermId());
    }

    public FeatureVectorUploader(IImagingQueryDAO imagingDao, HCSContainerDatasetInfo info, String dataSetPermID) {
        this.dao = imagingDao;
        this.info = info;
        this.dataSetPermID = dataSetPermID;
    }

    public void uploadFeatureVectors(List<CanonicalFeatureVector> fvecs) {
        long contId = ImagingDatabaseHelper.getOrCreateExperimentAndContainer(this.dao, this.info);
        long dataSetId = this.createFeatureVectorDataset(contId);
        FeatureVectorUploader.uploadFeatureVectors(this.dao, fvecs, dataSetId);
    }

    private long createFeatureVectorDataset(long contId) {
        ImgAnalysisDatasetDTO dataset = new ImgAnalysisDatasetDTO(this.dataSetPermID, contId);
        return this.dao.addAnalysisDataset(dataset);
    }

    public static void uploadFeatureVectors(IImagingQueryDAO dao, List<CanonicalFeatureVector> fvecs, long dataSetId) {
        for (CanonicalFeatureVector fvec : fvecs) {
            FeatureVectorUploaderHelper fvecUploader = new FeatureVectorUploaderHelper(dao, dataSetId, fvec);
            fvecUploader.createFeatureDef();
            fvecUploader.createFeatureValues();
            fvecUploader.createFeatureVocabularyTerms();
        }
    }

    private static class FeatureVectorUploaderHelper {
        private final IImagingQueryDAO dao;
        private final long dataSetId;
        private final CanonicalFeatureVector fvec;

        FeatureVectorUploaderHelper(IImagingQueryDAO dao, long dataSetId, CanonicalFeatureVector fvec) {
            this.dao = dao;
            this.dataSetId = dataSetId;
            this.fvec = fvec;
        }

        void createFeatureDef() {
            ImgFeatureDefDTO featureDef = this.fvec.getFeatureDef();
            featureDef.setDataSetId(this.dataSetId);
            long defId = this.dao.addFeatureDef(featureDef);
            featureDef.setId(defId);
        }

        void createFeatureValues() {
            ImgFeatureDefDTO featureDef = this.fvec.getFeatureDef();
            for (ImgFeatureValuesDTO featureValues : this.fvec.getValues()) {
                featureValues.setFeatureDefId(featureDef.getId());
                long valuesId = this.dao.addFeatureValues(featureValues);
                featureValues.setId(valuesId);
            }
        }

        void createFeatureVocabularyTerms() {
            List<ImgFeatureVocabularyTermDTO> terms = this.fvec.getVocabularyTerms();
            if (terms != null && terms.size() > 0) {
                long featureDefId = this.fvec.getFeatureDef().getId();
                for (ImgFeatureVocabularyTermDTO term : terms) {
                    term.setFeatureDefId(featureDefId);
                }
                this.dao.addFeatureVocabularyTerms(terms);
            }
        }
    }
}

