/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.genedata;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.Counters;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CanonicalFeatureVector;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateFeatureValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureValuesDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class GenedataFormatToCanonicalFeatureVector {
    private final String layerPrefix;
    private final List<String> lines;
    private final ArrayList<FeatureParser> features = new ArrayList();

    public GenedataFormatToCanonicalFeatureVector(List<String> lines, String layerPrefix) {
        this.layerPrefix = layerPrefix;
        this.lines = lines;
    }

    public ArrayList<CanonicalFeatureVector> convert() {
        this.readLines();
        return this.convertFeaturesToFeatureFectors();
    }

    private ArrayList<CanonicalFeatureVector> convertFeaturesToFeatureFectors() {
        ArrayList<CanonicalFeatureVector> result = new ArrayList<CanonicalFeatureVector>();
        Counters<String> counters = new Counters<String>();
        for (FeatureParser feature : this.features) {
            CanonicalFeatureVector featureVector = this.convertFeatureToFeatureVector(feature, counters);
            result.add(featureVector);
        }
        return result;
    }

    private CanonicalFeatureVector convertFeatureToFeatureVector(FeatureParser feature, Counters<String> counters) {
        Geometry geometry = Geometry.createFromRowColDimensions(feature.numberOfRows, feature.numberOfColumns);
        CanonicalFeatureVector featureVector = new CanonicalFeatureVector();
        String name = feature.name;
        String code = CodeNormalizer.normalize(name);
        int count = counters.count(code);
        ImgFeatureDefDTO featureDef = new ImgFeatureDefDTO();
        featureDef.setCode(count == 1 ? code : String.valueOf(code) + count);
        featureDef.setLabel(name);
        featureDef.setDescription(name);
        featureVector.setFeatureDef(featureDef);
        PlateFeatureValues valuesValues = this.convertColumnToValues(geometry, feature);
        ImgFeatureValuesDTO values = new ImgFeatureValuesDTO(0.0, 0.0, valuesValues, 0L);
        featureVector.setValues(Collections.singletonList(values));
        return featureVector;
    }

    private PlateFeatureValues convertColumnToValues(Geometry geometry, FeatureParser feature) {
        PlateFeatureValues doubleArray = new PlateFeatureValues(geometry);
        for (WellLocation loc : feature.values.keySet()) {
            Float value = (Float)feature.values.get(loc);
            doubleArray.setForWellLocation(value.floatValue(), loc);
        }
        return doubleArray;
    }

    private void readLines() {
        String featureName = null;
        ArrayList<String> featureLines = new ArrayList<String>();
        this.extractBarCode(this.lines.get(0).trim());
        int i = 1;
        while (i < this.lines.size()) {
            String line = this.lines.get(i).trim();
            if (!StringUtils.isEmpty((String)line)) {
                if (line.startsWith(this.getLayerPrefix())) {
                    if (!featureLines.isEmpty()) {
                        this.createFeature(featureName, featureLines);
                    }
                    featureName = this.extractLayer(line, i);
                    featureLines = new ArrayList();
                } else {
                    featureLines.add(line);
                }
            }
            ++i;
        }
        this.createFeature(featureName, featureLines);
    }

    private FeatureParser createFeature(String name, ArrayList<String> featureLines) {
        FeatureParser feature = new FeatureParser(name, featureLines);
        feature.parse();
        this.features.add(feature);
        return feature;
    }

    private String extractBarCode(String firstLine) {
        int indexOfEqual = firstLine.indexOf(61);
        if (indexOfEqual < 0) {
            throw this.error(0, firstLine, "Missing '='");
        }
        return firstLine.substring(indexOfEqual + 1).trim();
    }

    private String extractLayer(String line, int lineIndex) {
        String layer = line.substring(this.getLayerPrefix().length());
        if (!layer.endsWith(">")) {
            throw this.error(lineIndex, line, "Missing '>' at the end");
        }
        return layer.substring(0, layer.length() - 1);
    }

    private String getLayerPrefix() {
        return this.layerPrefix;
    }

    private UserFailureException error(int lineIndex, String line, String reason) {
        return new UserFailureException("Error in line " + lineIndex + 1 + ": " + reason + ": " + line);
    }

    private static class FeatureParser {
        private final String name;
        private final ArrayList<String> lines;
        private final ArrayList<String> rowLetters;
        private final int numberOfColumns;
        private final HashMap<WellLocation, Float> values;
        private int numberOfRows = 0;

        private FeatureParser(String name, ArrayList<String> lines) {
            this.name = name;
            this.lines = lines;
            this.numberOfColumns = this.computeNumberOfColumns(lines);
            this.values = new HashMap();
            this.rowLetters = new ArrayList();
        }

        private int computeNumberOfColumns(List<String> aList) {
            StringTokenizer tokenizer = new StringTokenizer(aList.get(0));
            return tokenizer.countTokens();
        }

        public void parse() {
            int i = 1;
            while (i < this.lines.size()) {
                this.parseLine(this.lines.get(i), i);
                ++i;
            }
            this.numberOfRows = this.rowLetters.size();
        }

        private void parseLine(String line, int lineIndex) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            int countTokens = tokenizer.countTokens();
            if (countTokens != this.numberOfColumns + 1) {
                throw this.error(lineIndex, line, "Inconsistent number of features: Expected " + this.numberOfColumns + " but was " + (countTokens - 1));
            }
            String rowLetter = tokenizer.nextToken();
            if (!this.rowLetters.contains(rowLetter)) {
                this.rowLetters.add(rowLetter);
            }
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                WellLocation wellLocation = WellLocation.parseLocationStr(rowLetter, i + 1);
                try {
                    this.values.put(wellLocation, Float.valueOf(Float.parseFloat(token)));
                }
                catch (NumberFormatException numberFormatException) {
                    this.values.put(wellLocation, Float.valueOf(Float.NaN));
                }
                ++i;
            }
        }

        private UserFailureException error(int lineIndex, String line, String reason) {
            return new UserFailureException("Error in line " + lineIndex + 1 + ": " + reason + ": " + line);
        }
    }
}

