/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.jython.v2;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonTopLevelDataSetHandlerV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.openbis.dss.etl.PlateGeometryOracle;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.IFeaturesBuilder;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureDefinition;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureVectorDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeaturesBuilder;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.IImagingDatasetFactory;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CsvFeatureVectorParser;
import ch.systemsx.cisd.openbis.dss.etl.jython.v2.FeatureVectorContainerDataSetRegistrationFactory;
import ch.systemsx.cisd.openbis.dss.etl.jython.v2.JythonImageContainerDataSetRegistrationFactory;
import ch.systemsx.cisd.openbis.dss.etl.jython.v2.JythonImageDataSetRegistrationFactory;
import ch.systemsx.cisd.openbis.dss.etl.jython.v2.SimpleImageDataSetRegistrator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class JythonPlateDatasetFactory
extends JythonTopLevelDataSetHandlerV2.ProgrammableDropboxObjectFactory<DataSetInformation>
implements IImagingDatasetFactory {
    final IDataSetRegistrationDetailsFactory<ImageDataSetInformation> imageDatasetFactory;
    final IDataSetRegistrationDetailsFactory<DataSetInformation> imageContainerDatasetFactory;
    final IDataSetRegistrationDetailsFactory<DataSetInformation> featureVectorContainerDatasetFactory;
    final IDataSetRegistrationDetailsFactory<FeatureVectorDataSetInformation> featureVectorDatasetFactory;

    public JythonPlateDatasetFactory(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState, DataSetInformation userProvidedDataSetInformationOrNull) {
        super(registratorState, userProvidedDataSetInformationOrNull);
        this.imageContainerDatasetFactory = new JythonImageContainerDataSetRegistrationFactory(this.registratorState, this.userProvidedDataSetInformationOrNull);
        this.imageDatasetFactory = new JythonImageDataSetRegistrationFactory(this.registratorState, this.userProvidedDataSetInformationOrNull);
        this.featureVectorDatasetFactory = new JythonTopLevelDataSetHandlerV2.ProgrammableDropboxObjectFactory<FeatureVectorDataSetInformation>(this.registratorState, this.userProvidedDataSetInformationOrNull){

            @Override
            protected FeatureVectorDataSetInformation createDataSetInformation() {
                return new FeatureVectorDataSetInformation();
            }
        };
        this.featureVectorContainerDatasetFactory = new FeatureVectorContainerDataSetRegistrationFactory(this.registratorState, this.userProvidedDataSetInformationOrNull);
    }

    @Override
    protected DataSetInformation createDataSetInformation() {
        return new DataSetInformation();
    }

    @Override
    public DataSetRegistrationDetails<ImageDataSetInformation> createImageRegistrationDetails(SimpleImageDataConfig imageDataSet, File incomingDatasetFolder) {
        return SimpleImageDataSetRegistrator.createImageDatasetDetails(imageDataSet, incomingDatasetFolder, this.imageDatasetFactory);
    }

    @Override
    public boolean registerImageDataset(SimpleImageDataConfig imageDataSet, File incomingDatasetFolder, DataSetRegistrationService<ImageDataSetInformation> service) {
        DataSetRegistrationDetails<ImageDataSetInformation> imageDatasetDetails = this.createImageRegistrationDetails(imageDataSet, incomingDatasetFolder);
        return this.registerImageDataset(imageDatasetDetails, incomingDatasetFolder, service);
    }

    @Override
    public boolean registerImageDataset(DataSetRegistrationDetails<ImageDataSetInformation> imageDatasetDetails, File incomingDatasetFolder, DataSetRegistrationService<ImageDataSetInformation> service) {
        DataSetRegistrationTransaction<ImageDataSetInformation> transaction = service.transaction(incomingDatasetFolder, service.getDataSetRegistrationDetailsFactory());
        IDataSet newDataset = transaction.createNewDataSet(imageDatasetDetails);
        transaction.moveFile(incomingDatasetFolder.getPath(), newDataset);
        return transaction.commit();
    }

    @Override
    public String figureGeometry(DataSetRegistrationDetails<ImageDataSetInformation> registrationDetails) {
        IEncapsulatedOpenBISService openBisService = this.registratorState.getGlobalState().getOpenBisService();
        return PlateGeometryOracle.figureGeometry(registrationDetails, openBisService);
    }

    @Override
    public IFeaturesBuilder createFeaturesBuilder() {
        return new FeaturesBuilder();
    }

    @Override
    public DataSetRegistrationDetails<FeatureVectorDataSetInformation> createFeatureVectorDatasetDetails(IFeaturesBuilder featureBuilder) {
        FeaturesBuilder myFeatureBuilder = (FeaturesBuilder)featureBuilder;
        List<FeatureDefinition> featureDefinitions = myFeatureBuilder.getFeatureDefinitionValuesList();
        return this.createFeatureVectorRegistrationDetails(featureDefinitions);
    }

    @Override
    public DataSetRegistrationDetails<FeatureVectorDataSetInformation> createFeatureVectorDatasetDetails(String csvFilePath, Properties properties) throws IOException {
        List<FeatureDefinition> featureDefinitions = CsvFeatureVectorParser.parse(new File(csvFilePath), properties);
        return this.createFeatureVectorRegistrationDetails(featureDefinitions);
    }

    public DataSetRegistrationDetails<FeatureVectorDataSetInformation> createFeatureVectorRegistrationDetails(List<FeatureDefinition> featureDefinitions) {
        DataSetRegistrationDetails<FeatureVectorDataSetInformation> registrationDetails = this.featureVectorDatasetFactory.createDataSetRegistrationDetails();
        FeatureVectorDataSetInformation featureVectorDataSet = registrationDetails.getDataSetInformation();
        featureVectorDataSet.setFeatures(featureDefinitions);
        registrationDetails.setDataSetType("HCS_ANALYSIS_WELL_FEATURES");
        registrationDetails.setMeasuredData(false);
        if (!featureVectorDataSet.isNotEmpty()) {
            throw new UserFailureException("The feature vector dataset does not contain any features.");
        }
        return registrationDetails;
    }

    @Deprecated
    public DataSetRegistrationDetails<FeatureVectorDataSetInformation> createFeatureVectorRegistrationDetails(IFeaturesBuilder featureBuilder, Object incomingDatasetFolder) {
        return this.createFeatureVectorDatasetDetails(featureBuilder);
    }

    @Deprecated
    public DataSetRegistrationDetails<FeatureVectorDataSetInformation> createFeatureVectorRegistrationDetails(String csvFilePath, Properties properties) throws IOException {
        return this.createFeatureVectorDatasetDetails(csvFilePath, properties);
    }
}

