/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.jython.v2;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageIdentifier;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageMetadata;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.IntensityRange;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Location;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleOverviewImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformationBuffer;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAcquiredImageEnrichedDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageTransformationDTO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class SimpleImageDataSetRegistrator {
    public static final String OPTIMAL_DATASET_INTENSITY_RESCALING_DESCRIPTION = "Optimal intensity rescaling for a series of images. It allows to compare images of one plate's dataset to each other.At the same time it causes that the conversion to 8 bit color depth looses less information, especially when images use only a small part of available intensities range.";
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SimpleImageDataSetRegistrator.class);
    private final SimpleImageDataConfig simpleImageConfig;
    private final IImageReaderFactory readerFactory;

    public static DataSetRegistrationDetails<ImageDataSetInformation> createImageDatasetDetails(SimpleImageDataConfig simpleImageConfig, File incoming, IDataSetRegistrationDetailsFactory<ImageDataSetInformation> factory) {
        return SimpleImageDataSetRegistrator.createImageDatasetDetails(simpleImageConfig, incoming, factory, new IImageReaderFactory(){

            @Override
            public IImageReader tryGetReaderForFile(String libraryName, String fileName) {
                return ImageReaderFactory.tryGetReaderForFile((String)libraryName, (String)fileName);
            }

            @Override
            public IImageReader tryGetReader(String libraryName, String readerName) {
                return ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
            }
        });
    }

    @Private
    static DataSetRegistrationDetails<ImageDataSetInformation> createImageDatasetDetails(SimpleImageDataConfig simpleImageConfig, File incoming, IDataSetRegistrationDetailsFactory<ImageDataSetInformation> factory, IImageReaderFactory readerFactory) {
        SimpleImageDataSetRegistrator registrator = new SimpleImageDataSetRegistrator(simpleImageConfig, readerFactory);
        return registrator.createImageDatasetDetails(incoming, factory);
    }

    private SimpleImageDataSetRegistrator(SimpleImageDataConfig simpleImageConfig, IImageReaderFactory readerFactory) {
        this.simpleImageConfig = simpleImageConfig;
        this.readerFactory = readerFactory;
    }

    private DataSetRegistrationDetails<ImageDataSetInformation> createImageDatasetDetails(File incoming, IDataSetRegistrationDetailsFactory<ImageDataSetInformation> imageDatasetFactory) {
        DataSetRegistrationDetails<ImageDataSetInformation> registrationDetails = imageDatasetFactory.createDataSetRegistrationDetails();
        ImageDataSetInformation imageDataset = registrationDetails.getDataSetInformation();
        if (this.simpleImageConfig instanceof SimpleOverviewImageDataConfig) {
            SimpleOverviewImageDataConfig simpleOverviewImageConfig = (SimpleOverviewImageDataConfig)this.simpleImageConfig;
            imageDataset.setContainerDatasetPermId(simpleOverviewImageConfig.getContainerDataSetCode());
            imageDataset.setGenerateOverviewImagesFromRegisteredImages(simpleOverviewImageConfig.isGenerateOverviewImagesFromRegisteredImages());
            imageDataset.setRegisterAsOverviewImageDataSet(true);
        }
        this.setImageDataset(incoming, imageDataset);
        List<Channel> channels = this.simpleImageConfig.getChannels();
        if (channels != null) {
            List<ChannelColorComponent> channelColorComponentsOrNull = this.simpleImageConfig.getChannelColorComponentsOrNull();
            if (channelColorComponentsOrNull == null) {
                imageDataset.setChannels(channels);
            } else {
                imageDataset.setChannels(channels, channelColorComponentsOrNull);
            }
        }
        imageDataset.setColorDepth(this.simpleImageConfig.getColorDepth());
        this.setRegistrationDetails(registrationDetails, imageDataset);
        return registrationDetails;
    }

    private List<File> listImageFiles(File incoming) {
        String[] extensions = this.simpleImageConfig.getRecognizedImageExtensions();
        if (incoming.isFile()) {
            ArrayList<File> list = new ArrayList<File>();
            if (this.extensionMatches(incoming, extensions)) {
                list.add(incoming);
            }
            return list;
        }
        return FileOperations.getInstance().listFiles(incoming, extensions, true);
    }

    private boolean extensionMatches(File incoming, String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            return true;
        }
        String fileExt = FilenameUtils.getExtension((String)incoming.getName());
        if (fileExt == null) {
            fileExt = "";
        }
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (ext.equalsIgnoreCase(fileExt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected List<ImageTokensWithPath> parseImageTokens(List<File> imageFiles, File incomingDirectory, IImageReader imageReaderOrNull) {
        ArrayList<ImageTokensWithPath> imageTokensList = new ArrayList<ImageTokensWithPath>();
        for (File imageFile : imageFiles) {
            try {
                ImageMetadata[] imageTokens;
                File file = new File(imageFile.getPath());
                List<ImageIdentifier> identifiers = SimpleImageDataSetRegistrator.getImageIdentifiers(imageReaderOrNull, file);
                String imageRelativePath = FileUtilities.getRelativeFilePath(incomingDirectory, file);
                ImageMetadata[] imageMetadataArray = imageTokens = this.simpleImageConfig.extractImagesMetadata(imageRelativePath, identifiers);
                int n = imageTokens.length;
                int n2 = 0;
                while (n2 < n) {
                    ImageMetadata imageToken = imageMetadataArray[n2];
                    imageToken.ensureValid(this.simpleImageConfig.isMicroscopyData());
                    imageTokensList.add(new ImageTokensWithPath(imageToken, imageRelativePath));
                    ++n2;
                }
            }
            catch (Exception ex) {
                throw new UserFailureException("Error ocured when processing image " + imageFile.getPath(), ex);
            }
        }
        if (imageTokensList.isEmpty()) {
            throw UserFailureException.fromTemplate("No image tokens could be parsed from incoming directory '%s' for extensions %s!", incomingDirectory.getPath(), CollectionUtils.abbreviate(this.simpleImageConfig.getRecognizedImageExtensions(), -1));
        }
        return imageTokensList;
    }

    private List<File> extractImageFiles(File incoming) {
        List<File> imageFiles = this.listImageFiles(incoming);
        if (imageFiles.isEmpty()) {
            throw UserFailureException.fromTemplate("Incoming directory '%s' contains no images with extensions %s!", incoming.getPath(), CollectionUtils.abbreviate(this.simpleImageConfig.getRecognizedImageExtensions(), -1));
        }
        return imageFiles;
    }

    private IImageReader tryCreateAndSaveImageReader(List<File> imageFiles) {
        IImageReader readerOrNull = null;
        ImageLibraryInfo imageLibraryInfoOrNull = this.tryGetImageLibrary();
        if (imageLibraryInfoOrNull != null) {
            readerOrNull = this.tryCreateImageReader(imageFiles, imageLibraryInfoOrNull);
            if (readerOrNull != null) {
                imageLibraryInfoOrNull.setReaderName(readerOrNull.getName());
            } else {
                throw ConfigurationFailureException.fromTemplate("Cannot find any reader for '%s' library.", imageLibraryInfoOrNull);
            }
        }
        return readerOrNull;
    }

    private IImageReader tryCreateImageReader(List<File> imageFiles, ImageLibraryInfo imageLibraryInfo) {
        if (imageFiles.isEmpty()) {
            return null;
        }
        File imageFile = imageFiles.get(0);
        String libraryName = imageLibraryInfo.getName();
        String readerNameOrNull = imageLibraryInfo.getReaderName();
        if (readerNameOrNull != null) {
            return this.readerFactory.tryGetReader(libraryName, readerNameOrNull);
        }
        return this.readerFactory.tryGetReaderForFile(libraryName, imageFile.getPath());
    }

    private ImageLibraryInfo tryGetImageLibrary() {
        return this.simpleImageConfig.getImageStorageConfiguration().tryGetImageLibrary();
    }

    private static List<ImageIdentifier> getImageIdentifiers(IImageReader readerOrNull, File imageFile) {
        ArrayList<ImageIdentifier> ids = new ArrayList<ImageIdentifier>();
        if (readerOrNull == null) {
            ids.add(ImageIdentifier.NULL);
        } else {
            List imageIDs = readerOrNull.getImageIDs(imageFile);
            for (ImageID imageID : imageIDs) {
                ids.add(new ImageIdentifier(imageID.getSeriesIndex(), imageID.getTimeSeriesIndex(), imageID.getFocalPlaneIndex(), imageID.getColorChannelIndex()));
            }
        }
        Collections.sort(ids);
        return ids;
    }

    protected ImageFileInfo createImageInfo(ImageTokensWithPath imageTokens, Geometry tileGeometry) {
        Location tileCoords = this.simpleImageConfig.getTileCoordinates(imageTokens.getTileNumber(), tileGeometry);
        ImageFileInfo img = new ImageFileInfo(imageTokens.getChannelCode(), tileCoords.getRow(), tileCoords.getColumn(), imageTokens.getImagePath());
        img.setTimepoint(imageTokens.tryGetTimepoint());
        img.setDepth(imageTokens.tryGetDepth());
        img.setSeriesNumber(imageTokens.tryGetSeriesNumber());
        img.setWell(imageTokens.getWell());
        img.setImageIdentifier(imageTokens.tryGetImageIdentifier());
        return img;
    }

    protected List<ImageFileInfo> createImageInfos(List<ImageTokensWithPath> imageTokensList, Geometry tileGeometry) {
        ArrayList<ImageFileInfo> images = new ArrayList<ImageFileInfo>();
        for (ImageTokensWithPath imageTokens : imageTokensList) {
            ImageFileInfo image = this.createImageInfo(imageTokens, tileGeometry);
            images.add(image);
        }
        return images;
    }

    private List<Channel> getAvailableChannels(List<ImageFileInfo> images) {
        LinkedHashSet<String> channelCodes = new LinkedHashSet<String>();
        for (ImageFileInfo image : images) {
            channelCodes.add(image.getChannelCode());
        }
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (String channelCode : channelCodes) {
            Channel channel = this.simpleImageConfig.createChannel(channelCode);
            channels.add(channel);
        }
        return channels;
    }

    private static int getMaxTileNumber(List<ImageTokensWithPath> imageTokensList) {
        int max = 0;
        for (ImageMetadata imageMetadata : imageTokensList) {
            max = Math.max(max, imageMetadata.getTileNumber());
        }
        return max;
    }

    private void computeAndAppendCommonFixedIntensityRangeTransformation(List<ImageFileInfo> images, File incomingDir, List<Channel> channels, IImageReader readerOrNull) {
        List<Channel> channelsForComputation = this.findChannelsToComputeFixedCommonIntensityRange(channels);
        Map<String, IntensityRange> map = this.simpleImageConfig.getFixedIntensityRangeForAllImages();
        IntensityRange defaultLevelsOrNull = map.get(null);
        for (Channel channel : channelsForComputation) {
            IntensityRange levelsOrNull = map.get(channel.getCode());
            IntensityRescaling.Levels intensityRange = levelsOrNull == null ? new IntensityRescaling.Levels(defaultLevelsOrNull.getBlackPoint(), defaultLevelsOrNull.getWhitePoint()) : new IntensityRescaling.Levels(levelsOrNull.getBlackPoint(), levelsOrNull.getWhitePoint());
            operationLog.info((Object)String.format("Set intensity range for channel '%s' to fixed value: %s (incoming directory '%s').", channel.getCode(), intensityRange.toString(), incomingDir.getName()));
            this.appendCommonIntensityRangeTransformation(channel, intensityRange);
        }
    }

    private List<Channel> findChannelsToComputeFixedCommonIntensityRange(List<Channel> channels) {
        Map<String, IntensityRange> map = this.simpleImageConfig.getFixedIntensityRangeForAllImages();
        IntensityRange defaultLevelOrNull = map.get(null);
        if (defaultLevelOrNull != null) {
            return channels;
        }
        Set<String> channelCodesSet = map.keySet();
        ArrayList<Channel> chosenChannels = new ArrayList<Channel>();
        for (Channel channel : channels) {
            if (!channelCodesSet.contains(channel.getCode())) continue;
            chosenChannels.add(channel);
        }
        return chosenChannels;
    }

    private void computeAndAppendCommonIntensityRangeTransformation(List<ImageFileInfo> images, File incomingDir, List<Channel> channels, IImageReader readerOrNull) {
        List<Channel> channelsForComputation = this.tryFindChannelsToComputeCommonIntensityRange(channels);
        if (channelsForComputation == null) {
            return;
        }
        for (Channel channel : channelsForComputation) {
            String channelCode = channel.getCode();
            List<File> imagePaths = SimpleImageDataSetRegistrator.chooseChannelImages(images, incomingDir, channelCode);
            operationLog.info((Object)String.format("Computing intensity range for channel '%s'. Found %d images for the channel in incoming directory '%s'.", channelCode, imagePaths.size(), incomingDir.getName()));
            IntensityRescaling.Levels intensityRange = SimpleImageDataSetRegistrator.tryComputeCommonIntensityRange(readerOrNull, imagePaths, this.simpleImageConfig.getComputeCommonIntensityRangeOfAllImagesThreshold());
            if (intensityRange != null) {
                operationLog.info((Object)String.format("Computed intensity range for channel '%s': %s (incoming directory '%s').", channelCode, intensityRange.toString(), incomingDir.getName()));
                this.appendCommonIntensityRangeTransformation(channel, intensityRange);
                continue;
            }
            operationLog.warn((Object)String.format("Transformation cannot be generated for channel '%s' (incoming directory '%s').", channelCode, incomingDir.getName()));
        }
    }

    private void appendCommonIntensityRangeTransformation(Channel channel, IntensityRescaling.Levels intensityRange) {
        ImageTransformationBuffer buffer = new ImageTransformationBuffer();
        String label = this.simpleImageConfig.getComputeCommonIntensityRangeOfAllImagesLabel();
        ImageTransformation imageTransformation = buffer.appendRescaleGrayscaleIntensity(intensityRange.getMinLevel(), intensityRange.getMaxLevel(), label);
        imageTransformation.setDescription(OPTIMAL_DATASET_INTENSITY_RESCALING_DESCRIPTION);
        boolean isDefault = this.simpleImageConfig.isComputeCommonIntensityRangeOfAllImagesDefault();
        imageTransformation.setDefault(isDefault);
        buffer.appendAll(channel.getAvailableTransformations());
        channel.setAvailableTransformations(buffer.getTransformations());
    }

    private static List<File> chooseChannelImages(List<ImageFileInfo> images, File incomingDir, String channelCode) {
        String normalizedChannelCode = CodeNormalizer.normalize(channelCode);
        ArrayList<File> channelImages = new ArrayList<File>();
        for (ImageFileInfo imageFileInfo : images) {
            String imageChannelCode = CodeNormalizer.normalize(imageFileInfo.getChannelCode());
            if (!imageChannelCode.equals(normalizedChannelCode)) continue;
            channelImages.add(new File(incomingDir, imageFileInfo.getImageRelativePath()));
        }
        return channelImages;
    }

    private List<Channel> tryFindChannelsToComputeCommonIntensityRange(List<Channel> channels) {
        List<String> channelCodes = this.simpleImageConfig.getComputeCommonIntensityRangeOfAllImagesForChannels();
        if (channelCodes == null) {
            return null;
        }
        if (channelCodes.isEmpty()) {
            return channels;
        }
        Set<String> channelCodesSet = SimpleImageDataSetRegistrator.createNormalizedCodesSet(channelCodes);
        ArrayList<Channel> chosenChannels = new ArrayList<Channel>();
        for (Channel channel : channels) {
            if (!channelCodesSet.contains(channel.getCode())) continue;
            chosenChannels.add(channel);
        }
        return chosenChannels;
    }

    private static Set<String> createNormalizedCodesSet(Collection<String> channelCodes) {
        HashSet<String> normalizedCodes = new HashSet<String>();
        for (String code : channelCodes) {
            normalizedCodes.add(CodeNormalizer.normalize(code));
        }
        return normalizedCodes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntensityRescaling.Levels tryComputeCommonIntensityRange(IImageReader readerOrNull, List<File> imageFiles, float threshold) {
        String libraryName = readerOrNull == null ? null : readerOrNull.getLibraryName();
        String readerName = readerOrNull == null ? null : readerOrNull.getName();
        IntensityRescaling.PixelHistogram histogram = new IntensityRescaling.PixelHistogram();
        for (File imageFile : imageFiles) {
            try {
                List<ImageIdentifier> imageIdentifiers = SimpleImageDataSetRegistrator.getImageIdentifiers(readerOrNull, imageFile);
                for (ImageIdentifier imageIdentifier : imageIdentifiers) {
                    BufferedImage image = SimpleImageDataSetRegistrator.loadUnchangedImage(imageFile, imageIdentifier, libraryName, readerName);
                    if (IntensityRescaling.isNotGrayscale(image)) {
                        operationLog.warn((Object)String.format("Intensity range cannot be computed because image '%s' is not in grayscale.", imageFile.getPath()));
                        return null;
                    }
                    IntensityRescaling.addToLevelStats(histogram, image);
                }
            }
            catch (Exception ex) {
                throw new UserFailureException("Error ocured when processing image " + imageFile.getPath(), ex);
            }
        }
        return IntensityRescaling.computeLevels(histogram, threshold);
    }

    private static BufferedImage loadUnchangedImage(File imageFile, ImageIdentifier imageIdentifier, String libraryName, String readerName) {
        String imageStringIdentifier = imageIdentifier.getUniqueStringIdentifier();
        return ImageUtil.loadUnchangedImage(new FileBasedContentNode(imageFile), imageStringIdentifier, libraryName, readerName, null);
    }

    protected void setImageDataset(File incoming, ImageDataSetInformation dataset) {
        dataset.setDatasetTypeCode(this.simpleImageConfig.getDataSetType());
        dataset.setFileFormatCode(this.simpleImageConfig.getFileFormatType());
        dataset.setMeasured(this.simpleImageConfig.isMeasuredData());
        dataset.setSample(this.simpleImageConfig.getPlateSpace(), this.simpleImageConfig.getPlateCode());
        dataset.setIncomingDirectory(incoming);
        ImageDataSetStructure imageStruct = this.createImageDataSetStructure(incoming, dataset);
        dataset.setImageDataSetStructure(imageStruct);
    }

    private ImageDataSetStructure createImageDataSetStructure(File incoming, ImageDataSetInformation dataset) {
        List<ImageFileInfo> images = null;
        List<Channel> channels = null;
        Geometry tileGeometry = null;
        if (dataset.isGenerateOverviewImagesFromRegisteredImages()) {
            images = new ArrayList<ImageFileInfo>();
            channels = new ArrayList<Channel>();
            tileGeometry = this.extractImageFileInfos(dataset, images, channels);
        } else {
            List<File> imageFiles = this.extractImageFiles(incoming);
            IImageReader imageReaderOrNull = this.tryCreateAndSaveImageReader(imageFiles);
            List<ImageTokensWithPath> imageTokensList = this.parseImageTokens(imageFiles, incoming, imageReaderOrNull);
            int maxTileNumber = SimpleImageDataSetRegistrator.getMaxTileNumber(imageTokensList);
            tileGeometry = this.simpleImageConfig.getTileGeometry(imageTokensList, maxTileNumber);
            images = this.createImageInfos(imageTokensList, tileGeometry);
            channels = this.getAvailableChannels(images);
            if (this.simpleImageConfig.isFixedIntensityRangeForAllImagesDefined()) {
                this.computeAndAppendCommonFixedIntensityRangeTransformation(images, incoming, channels, imageReaderOrNull);
            } else {
                this.computeAndAppendCommonIntensityRangeTransformation(images, incoming, channels, imageReaderOrNull);
            }
        }
        ImageDataSetStructure imageStruct = new ImageDataSetStructure();
        imageStruct.setImages(images);
        imageStruct.setChannels(channels);
        imageStruct.setTileGeometry(tileGeometry.getNumberOfRows(), tileGeometry.getNumberOfColumns());
        imageStruct.setImageStorageConfiguraton(this.simpleImageConfig.getImageStorageConfiguration());
        return imageStruct;
    }

    private Geometry extractImageFileInfos(DataSetInformation dataset, List<ImageFileInfo> images, List<Channel> channels) {
        IImagingReadonlyQueryDAO query = DssScreeningUtils.getQuery();
        List<ImgImageDatasetDTO> containers = DssScreeningUtils.getQuery().listImageDatasetsByPermId(dataset.tryGetContainerDatasetPermId());
        Iterator<ImgImageDatasetDTO> iterator = containers.iterator();
        if (iterator.hasNext()) {
            ImgImageDatasetDTO container = iterator.next();
            List<ImgAcquiredImageEnrichedDTO> acquiredImages = query.listAllEnrichedAcquiredImagesForDataSet(container.getId());
            for (ImgAcquiredImageEnrichedDTO acquiredImage : acquiredImages) {
                images.add(this.createImageFileInfo(container, acquiredImage));
            }
            List<ImgChannelDTO> channelDTOs = query.getChannelsByDatasetId(container.getId());
            for (ImgChannelDTO channelDTO : channelDTOs) {
                Channel channel = this.createChannel(query, channelDTO);
                channels.add(channel);
            }
            return Geometry.createFromRowColDimensions(container.getFieldNumberOfRows(), container.getFieldNumberOfColumns());
        }
        return null;
    }

    private Channel createChannel(IImagingReadonlyQueryDAO query, ImgChannelDTO channelDTO) {
        Channel channel = new Channel(channelDTO.getCode(), channelDTO.getLabel(), new ChannelColorRGB(channelDTO.getRedColorComponent(), channelDTO.getGreenColorComponent(), channelDTO.getBlueColorComponent()));
        channel.setDescription(channelDTO.getDescription());
        channel.setWavelength(channelDTO.getWavelength());
        List<ImgImageTransformationDTO> transformationDTOs = query.listImageTransformations(channelDTO.getId());
        ImageTransformation[] transformations = new ImageTransformation[transformationDTOs.size()];
        int counter = 0;
        for (ImgImageTransformationDTO transformationDTO : transformationDTOs) {
            ImageTransformation transformation = new ImageTransformation(transformationDTO.getCode(), transformationDTO.getLabel(), transformationDTO.getDescription(), transformationDTO.getImageTransformerFactory());
            transformations[counter++] = transformation;
        }
        channel.setAvailableTransformations(transformations);
        return channel;
    }

    private ImageFileInfo createImageFileInfo(ImgImageDatasetDTO container, ImgAcquiredImageEnrichedDTO acquiredImage) {
        ImageFileInfo img = new ImageFileInfo(acquiredImage.getChannelCode(), acquiredImage.getTileRow(), acquiredImage.getTileColumn(), acquiredImage.getImageFilePath());
        img.setTimepoint(acquiredImage.getT());
        img.setDepth(acquiredImage.getZ());
        img.setSeriesNumber(acquiredImage.getSeriesNumber());
        if (acquiredImage.getSpotRow() != null && acquiredImage.getSpotColumn() != null) {
            img.setWell(acquiredImage.getSpotRow(), acquiredImage.getSpotColumn());
        }
        img.setUniqueImageIdentifier(acquiredImage.getImageIdOrNull());
        img.setContainerDataSetCode(container.getPermId());
        return img;
    }

    private <T extends DataSetInformation> void setRegistrationDetails(DataSetRegistrationDetails<T> registrationDetails, T dataset) {
        registrationDetails.setDataSetInformation(dataset);
        registrationDetails.setFileFormatType(new FileFormatType(this.simpleImageConfig.getFileFormatType()));
        registrationDetails.setDataSetType(new DataSetType(this.simpleImageConfig.getDataSetType()));
        registrationDetails.setMeasuredData(this.simpleImageConfig.isMeasuredData());
    }

    @Private
    static interface IImageReaderFactory {
        public IImageReader tryGetReader(String var1, String var2);

        public IImageReader tryGetReaderForFile(String var1, String var2);
    }

    private static class ImageTokensWithPath
    extends ImageMetadata {
        private String imageRelativePath;

        public ImageTokensWithPath(ImageMetadata imageTokens, String imageRelativePath) {
            this.setWell(imageTokens.getWell());
            this.setChannelCode(imageTokens.getChannelCode());
            this.setTileNumber(imageTokens.getTileNumber());
            this.setDepth(imageTokens.tryGetDepth());
            this.setTimepoint(imageTokens.tryGetTimepoint());
            this.setSeriesNumber(imageTokens.tryGetSeriesNumber());
            this.setImageIdentifier(imageTokens.tryGetImageIdentifier());
            this.imageRelativePath = imageRelativePath;
        }

        public String getImagePath() {
            return this.imageRelativePath;
        }
    }
}

