/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.ImageGenerationDescriptionFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.DatasetAcquiredImagesReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageGenerationDescription;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

abstract class AbstractImagesDownloadServlet
extends AbstractDatasetDownloadServlet {
    private static final long serialVersionUID = 1L;

    AbstractImagesDownloadServlet() {
    }

    protected abstract ResponseContentStream createImageResponse(ImageGenerationDescription var1, IHierarchicalContentProvider var2) throws IOException, EnvironmentFailureException;

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImageGenerationDescription imageGenDesc = null;
        try {
            HttpSession session = this.tryGetOrCreateSession(request, ImageGenerationDescriptionFactory.getSessionId(request));
            if (session == null) {
                AbstractImagesDownloadServlet.printSessionExpired(response);
            } else {
                imageGenDesc = ImageGenerationDescriptionFactory.create(request);
                this.deliverFile(response, imageGenDesc, session);
            }
        }
        catch (Exception e) {
            String message = "Error: Couldn't deliver image";
            if (imageGenDesc != null) {
                message = String.valueOf(message) + " for " + imageGenDesc;
            }
            operationLog.error((Object)message, (Throwable)e);
            AbstractImagesDownloadServlet.printErrorResponse(response, message);
        }
    }

    protected void deliverFile(HttpServletResponse response, ImageGenerationDescription params, HttpSession session) throws IOException {
        ResponseContentStream responseStream;
        String sessionId = params.getSessionId();
        this.ensureDatasetsAccessible(params, session, sessionId);
        long start = System.currentTimeMillis();
        try {
            responseStream = this.createImageResponse(params, this.applicationContext.getHierarchicalContentProvider(sessionId));
        }
        catch (HighLevelException e) {
            operationLog.warn((Object)e.getMessage());
            AbstractImagesDownloadServlet.printErrorResponse(response, e.getMessage());
            return;
        }
        AbstractImagesDownloadServlet.logImageDelivery(params, responseStream, System.currentTimeMillis() - start);
        this.writeResponseContent(responseStream, response);
    }

    private void ensureDatasetsAccessible(ImageGenerationDescription params, HttpSession session, String sessionId) {
        this.ensureDatasetAccessible(params.tryGetImageChannels(), session, sessionId);
        List<DatasetAcquiredImagesReference> overlayChannels = params.getOverlayChannels();
        for (DatasetAcquiredImagesReference dataset : overlayChannels) {
            this.ensureDatasetAccessible(dataset, session, sessionId);
        }
    }

    private void ensureDatasetAccessible(DatasetAcquiredImagesReference dataset, HttpSession session, String sessionId) {
        if (dataset != null) {
            this.ensureDatasetAccessible(dataset.getDatasetCode(), session, sessionId);
        }
    }

    protected static final void logImageDelivery(ImageGenerationDescription params, ResponseContentStream responseStream, long timeTaken) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("For '" + params + "' delivering image (" + responseStream.getSize() + " bytes) took " + timeTaken + " msec"));
        }
    }
}

