/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.dss.generic.server.ConfigParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.OpenbisSessionTokenCache;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;

class ApplicationContext {
    private final IEncapsulatedOpenBISService dataSetService;
    private final IShareIdManager shareIdManager;
    private final ConfigParameters configParameters;
    private final IHierarchicalContentProvider hierarchicalContentProvider;
    private final OpenbisSessionTokenCache sessionTokenCache;

    ApplicationContext(IEncapsulatedOpenBISService service, OpenbisSessionTokenCache sessionTokenCache, IShareIdManager shareIdManager, IHierarchicalContentProvider hierarchicalContentProvider, ConfigParameters configParameters) {
        this.dataSetService = service;
        this.sessionTokenCache = sessionTokenCache;
        this.shareIdManager = shareIdManager;
        this.configParameters = configParameters;
        this.hierarchicalContentProvider = hierarchicalContentProvider;
    }

    public final IEncapsulatedOpenBISService getDataSetService() {
        return this.dataSetService;
    }

    public OpenbisSessionTokenCache getSessionTokenCache() {
        return this.sessionTokenCache;
    }

    public IShareIdManager getShareIdManager() {
        return this.shareIdManager;
    }

    public final ConfigParameters getConfigParameters() {
        return this.configParameters;
    }

    public IHierarchicalContentProvider getHierarchicalContentProvider(String sessionTokenOrNull) {
        if (sessionTokenOrNull == null) {
            return this.hierarchicalContentProvider;
        }
        OpenBISSessionHolder sessionHolder = new OpenBISSessionHolder();
        sessionHolder.setSessionToken(sessionTokenOrNull);
        return this.hierarchicalContentProvider.cloneFor(sessionHolder);
    }
}

