/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.IServletPropertiesManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.PluginServletConfig;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class ConfigParameters
implements IServletPropertiesManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ConfigParameters.class);
    static final String SERVER_URL_KEY = "server-url";
    static final String PORT_KEY = "port";
    static final String STOREROOT_DIR_KEY = "storeroot-dir";
    static final String SESSION_TIMEOUT_KEY = "session-timeout";
    static final String SERVER_TIMEOUT_IN_MINUTES = "server-timeout-in-minutes";
    static final int DEFAULT_SERVER_TIMEOUT_IN_MINUTES = 5;
    static final String DOWNLOAD_URL = "download-url";
    private static final String KEYSTORE = "keystore.";
    static final String USE_SSL = "use-ssl";
    static final boolean DEFAULT_USE_SSL = true;
    static final String USE_NIO = "use-nio-selector-socket";
    static final String AUTH_CACHE_EXPIRATION_TIME = "authorization-cache-expiration-time";
    static final String COMMAND_QUEUE_DIR = "commandqueue-dir";
    static final int DEFAULT_AUTH_CACHE_EXPIRATION_TIME_MINS = 5;
    static final String AUTH_CACHE_CLEANUP_TIMER_PERIOD = "authorization-cache-cleanup-timer-period";
    static final int DEFAULT_AUTH_CACHE_CLEANUP_TIMER_PERIOD_MINS = 180;
    public static final String KEYSTORE_PATH_KEY = "keystore.path";
    public static final String KEYSTORE_PASSWORD_KEY = "keystore.password";
    public static final String KEYSTORE_KEY_PASSWORD_KEY = "keystore.key-password";
    static final String PLUGIN_SERVICE_CLASS_KEY = "class";
    static final String PLUGIN_SERVICE_PATH_KEY = "path";
    static final String WEBSTART_JAR_PATH = "webstart-jar-path";
    static final String WEBSTART_JAR_PATH_DEFAULT = "lib";
    private final File storePath;
    private final File dssInternalTempDir;
    private final File dssRegistrationLogDir;
    private final File dssRecoveryStateDir;
    private final int port;
    private final String serverURL;
    private final String downloadURL;
    private final int sessionTimeout;
    private final int serverTimeoutInMinutes;
    private final boolean useSSL;
    private final boolean useNIO;
    private final String keystorePath;
    private final String keystorePassword;
    private final String keystoreKeyPassword;
    private final int authCacheExpirationTimeMins;
    private final int authCacheCleanupTimerPeriodMins;
    private final Map<String, PluginServletConfig> pluginServlets;
    private final Properties properties;
    private final String webstartJarPath;
    private final File commandQueueDir;

    ConfigParameters(Properties properties) {
        this.properties = properties;
        String storeRootDir = PropertyUtils.getMandatoryProperty(properties, STOREROOT_DIR_KEY);
        this.storePath = new File(storeRootDir);
        this.dssInternalTempDir = ConfigParameters.getInternalTempDirectory(properties);
        this.dssRegistrationLogDir = DssPropertyParametersUtil.getDssRegistrationLogDir(properties);
        this.dssRecoveryStateDir = DssPropertyParametersUtil.getDssRecoveryStateDir(properties);
        this.port = ConfigParameters.getMandatoryIntegerProperty(properties, PORT_KEY);
        this.serverURL = PropertyUtils.getMandatoryProperty(properties, SERVER_URL_KEY);
        this.downloadURL = PropertyUtils.getMandatoryProperty(properties, DOWNLOAD_URL);
        this.sessionTimeout = ConfigParameters.getMandatoryIntegerProperty(properties, SESSION_TIMEOUT_KEY) * 60;
        this.serverTimeoutInMinutes = PropertyUtils.getInt(properties, SERVER_TIMEOUT_IN_MINUTES, ConfigParameters.getDefaultServerTimeoutInMinutes());
        this.useSSL = PropertyUtils.getBoolean(properties, USE_SSL, ConfigParameters.getDefaultUseSSL());
        this.commandQueueDir = new File(PropertyUtils.getProperty(properties, COMMAND_QUEUE_DIR, storeRootDir));
        if (this.useSSL) {
            this.keystorePath = PropertyUtils.getMandatoryProperty(properties, KEYSTORE_PATH_KEY);
            this.keystorePassword = PropertyUtils.getMandatoryProperty(properties, KEYSTORE_PASSWORD_KEY);
            this.keystoreKeyPassword = PropertyUtils.getMandatoryProperty(properties, KEYSTORE_KEY_PASSWORD_KEY);
        } else {
            this.keystoreKeyPassword = null;
            this.keystorePassword = null;
            this.keystorePath = null;
        }
        this.useNIO = PropertyUtils.getBoolean(properties, USE_NIO, false);
        this.authCacheExpirationTimeMins = PropertyUtils.getInt(properties, AUTH_CACHE_EXPIRATION_TIME, 5);
        this.authCacheCleanupTimerPeriodMins = PropertyUtils.getInt(properties, AUTH_CACHE_CLEANUP_TIMER_PERIOD, 180);
        this.pluginServlets = new LinkedHashMap<String, PluginServletConfig>();
        this.addSystemServlets();
        PropertyParametersUtil.SectionProperties[] pluginServicesProperties = PropertyParametersUtil.extractSectionProperties(properties, "plugin-services", false);
        this.addServletsProperties("", pluginServicesProperties);
        this.webstartJarPath = PropertyUtils.getProperty(properties, WEBSTART_JAR_PATH, WEBSTART_JAR_PATH_DEFAULT);
    }

    private static File getInternalTempDirectory(Properties properties) {
        return DssPropertyParametersUtil.getDssInternalTempDir(properties);
    }

    @Override
    public void addServletsProperties(String keyPrefix, PropertyParametersUtil.SectionProperties[] servletsProperties) {
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = servletsProperties;
        int n = servletsProperties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperties = sectionPropertiesArray[n2];
            Properties servletProps = sectionProperties.getProperties();
            String key = String.valueOf(keyPrefix) + sectionProperties.getKey();
            this.addServletProperties(key, servletProps);
            ++n2;
        }
    }

    private void addSystemServlets() {
        String servletClass = "ch.systemsx.cisd.openbis.dss.generic.server.DynamicFileTabularDataGraphServlet";
        String servletPath = "/graphservice/*";
        PluginServletConfig servletConfig = new PluginServletConfig(servletClass, servletPath, new Properties());
        this.pluginServlets.put(servletPath, servletConfig);
    }

    @Override
    public void addServletProperties(String propertiesName, Properties servletProperties) {
        String servletClass = PropertyUtils.getMandatoryProperty(servletProperties, PLUGIN_SERVICE_CLASS_KEY);
        String servletPath = PropertyUtils.getMandatoryProperty(servletProperties, PLUGIN_SERVICE_PATH_KEY);
        PluginServletConfig servletConfig = new PluginServletConfig(servletClass, servletPath, servletProperties);
        if (this.pluginServlets.containsKey(servletPath)) {
            throw new ConfigurationFailureException("Servlet configuration [" + propertiesName + "]: There has already been a servlet configured for the path '" + servletPath + "'.");
        }
        this.pluginServlets.put(servletPath, servletConfig);
    }

    private static final int getMandatoryIntegerProperty(Properties properties, String key) {
        String property = PropertyUtils.getMandatoryProperty(properties, key);
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationFailureException("Configuration parameter '" + key + "' is not an integer number: " + property);
        }
    }

    public final File getStorePath() {
        return this.storePath;
    }

    public File getCommandQueueDir() {
        return this.commandQueueDir;
    }

    public File getDssInternalTempDir() {
        return this.dssInternalTempDir;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getServerURL() {
        return this.serverURL;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public final int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getServerTimeoutInMinutes() {
        return this.serverTimeoutInMinutes;
    }

    public static int getDefaultServerTimeoutInMinutes() {
        return 5;
    }

    public final String getKeystorePath() {
        return this.keystorePath;
    }

    public final String getKeystorePassword() {
        return this.keystorePassword;
    }

    public final String getKeystoreKeyPassword() {
        return this.keystoreKeyPassword;
    }

    public final List<PluginServletConfig> getPluginServlets() {
        return new ArrayList<PluginServletConfig>(this.pluginServlets.values());
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public static boolean getDefaultUseSSL() {
        return true;
    }

    public boolean isUseNIO() {
        return this.useNIO;
    }

    public int getAuthCacheExpirationTimeMins() {
        return this.authCacheExpirationTimeMins;
    }

    public int getAuthCacheCleanupTimerPeriodMins() {
        return this.authCacheCleanupTimerPeriodMins;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getWebstartJarPath() {
        return this.webstartJarPath;
    }

    public final void log() {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Store root directory: '%s'.", this.storePath));
            operationLog.info((Object)String.format("Temp file directory: '%s'.", this.dssInternalTempDir));
            operationLog.info((Object)String.format("DSS registration log directory: '%s'.", this.dssRegistrationLogDir));
            operationLog.info((Object)String.format("DSS recovery state directory: '%s'.", this.dssRecoveryStateDir));
            operationLog.info((Object)String.format("Port number: %d.", this.port));
            operationLog.info((Object)String.format("URL of openBIS server: '%s'.", this.serverURL));
            operationLog.info((Object)String.format("Session timeout (seconds): %d.", this.sessionTimeout));
            operationLog.info((Object)String.format("Server timeout (minutes): %d.", this.serverTimeoutInMinutes));
            operationLog.info((Object)String.format("Use SSL: %s.", this.useSSL));
            operationLog.info((Object)String.format("Use NIO sockets: %s", this.useNIO));
            operationLog.info((Object)String.format("Authorization cache expiration time (minutes): %s", this.authCacheExpirationTimeMins));
            operationLog.info((Object)String.format("Authorization cache cleanup timer period (minutes): %s", this.authCacheCleanupTimerPeriodMins));
            operationLog.info((Object)String.format("Keystore path: '%s'.", this.keystorePath));
            for (PluginServletConfig pluginServlet : this.getPluginServlets()) {
                operationLog.info((Object)("Plugin servlet: " + pluginServlet));
            }
        }
    }
}

