/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetLocationBasedCommand;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

class DeletionCommand
extends AbstractDataSetLocationBasedCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DeletionCommand.class);
    private final int maxNumberOfRetries;
    private final long waitingTimeBetweenRetries;

    DeletionCommand(List<? extends IDatasetLocation> dataSets, int maxNumberOfRetries, long waitingTimeBetweenRetries) {
        super(dataSets);
        this.maxNumberOfRetries = maxNumberOfRetries;
        this.waitingTimeBetweenRetries = waitingTimeBetweenRetries;
    }

    @Override
    public void execute(IHierarchicalContentProvider contentProvider, final IDataSetDirectoryProvider dataSetDirectoryProvider) {
        final IShareIdManager shareIdManager = dataSetDirectoryProvider.getShareIdManager();
        final ISimpleLogger logger = this.createLogger();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 360L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        DataSetExistenceChecker dataSetExistenceChecker = new DataSetExistenceChecker(dataSetDirectoryProvider, this.waitingTimeBetweenRetries, this.maxNumberOfRetries);
        for (final IDatasetLocation dataSet : this.dataSets) {
            if (!dataSetExistenceChecker.dataSetExists(dataSet)) continue;
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        SegmentedStoreUtils.deleteDataSet(dataSet, dataSetDirectoryProvider, shareIdManager, logger);
                    }
                    catch (Throwable ex) {
                        logger.log(LogLevel.ERROR, "Couldn't delete " + dataSet + ", reason: " + ex);
                    }
                }
            });
        }
    }

    @Private
    ISimpleLogger createLogger() {
        return new Log4jSimpleLogger(operationLog);
    }

    @Override
    public String getDescription() {
        StringBuilder b = new StringBuilder();
        b.append("Delete data sets: ");
        for (IDatasetLocation dataset : this.dataSets) {
            b.append(dataset.getDataSetCode());
            b.append(',');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }
}

