/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.AnnotationUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.AuthorizationGuard;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.DataSetAccessGuard;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.DssSessionAuthorizationHolder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.IDssSessionAuthorizer;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.PrivilegeLevel;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.authorization.IAuthorizationGuardPredicate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;

public class DssServiceRpcAuthorizationAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DssServiceRpcAuthorizationAdvisor.class);
    private static final Logger authorizationLog = LogFactory.getLogger(LogCategory.AUTH, DssServiceRpcAuthorizationAdvisor.class);

    public DssServiceRpcAuthorizationAdvisor() {
        this(new DssServiceRpcAuthorizationMethodInterceptor(null));
    }

    public DssServiceRpcAuthorizationAdvisor(IShareIdManager shareIdManager) {
        this(new DssServiceRpcAuthorizationMethodInterceptor(shareIdManager));
    }

    public DssServiceRpcAuthorizationAdvisor(MethodInterceptor methodInterceptor) {
        super((Pointcut)new AnnotationMatchingPointcut(null, DataSetAccessGuard.class), (Advice)methodInterceptor);
    }

    public static class DssServiceRpcAuthorizationMethodInterceptor
    implements MethodInterceptor {
        private IShareIdManager shareIdManager;

        public DssServiceRpcAuthorizationMethodInterceptor(IShareIdManager shareIdManager) {
            this.shareIdManager = shareIdManager;
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            Object[] args = methodInvocation.getArguments();
            String sessionToken = DssServiceRpcAuthorizationMethodInterceptor.getSessionToken(args);
            List<AnnotationUtils.Parameter<AuthorizationGuard>> annotatedParameters = AnnotationUtils.getAnnotatedParameters(methodInvocation.getMethod(), AuthorizationGuard.class);
            IShareIdManager manager = this.getShareIdManager();
            ArrayList<String> dataSetCodes = new ArrayList<String>();
            for (AnnotationUtils.Parameter<AuthorizationGuard> param : annotatedParameters) {
                Object guarded = args[param.getIndex()];
                dataSetCodes.addAll(this.getDataSetCodes(param, guarded));
            }
            boolean shouldLocksAutomaticallyBeReleased = this.shouldLocksAutomaticallyBeReleased(methodInvocation.getMethod());
            if (!dataSetCodes.isEmpty()) {
                manager.lock(dataSetCodes);
            }
            try {
                Object result;
                assert (args.length <= 1 || annotatedParameters.size() > 0) : "No guard defined";
                PrivilegeLevel level = this.getAndCheckPrivilegeLevel(sessionToken, methodInvocation.getMethod());
                if (level != PrivilegeLevel.INSTANCE_ADMIN) {
                    Object recv = methodInvocation.getThis();
                    for (AnnotationUtils.Parameter<AuthorizationGuard> param : annotatedParameters) {
                        Object guarded;
                        Status status = this.evaluateGuard(sessionToken, recv, param, guarded = args[param.getIndex()]);
                        if (status == Status.OK) continue;
                        authorizationLog.info((Object)String.format("[SESSION:'%s' DATA_SET:%s]: Authorization failure while invoking method '%s'", sessionToken, guarded, MethodUtils.describeMethod(methodInvocation.getMethod())));
                        String errorMessage = "Data set does not exist.";
                        if (status.tryGetErrorMessage() != null) {
                            errorMessage = status.tryGetErrorMessage();
                        }
                        throw new AuthorizationFailureException(errorMessage);
                    }
                }
                if ((result = methodInvocation.proceed()) instanceof InputStream) {
                    shouldLocksAutomaticallyBeReleased = false;
                    result = new InputStreamProxy((InputStream)result, manager);
                }
                Object object = result;
                return object;
            }
            finally {
                if (shouldLocksAutomaticallyBeReleased) {
                    manager.releaseLocks();
                }
            }
        }

        private boolean shouldLocksAutomaticallyBeReleased(Method method) {
            DataSetAccessGuard guard = method.getAnnotation(DataSetAccessGuard.class);
            return guard == null ? true : guard.releaseDataSetLocks();
        }

        private PrivilegeLevel getAndCheckPrivilegeLevel(String sessionToken, Method method) {
            Status status;
            PrivilegeLevel level;
            DataSetAccessGuard guard = method.getAnnotation(DataSetAccessGuard.class);
            PrivilegeLevel privilegeLevel = level = guard == null ? PrivilegeLevel.DEFAULT : guard.privilegeLevel();
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Check access for privilege level " + (Object)((Object)level)));
            }
            IDssSessionAuthorizer authorizer = DssSessionAuthorizationHolder.getAuthorizer();
            switch (level) {
                case INSTANCE_ADMIN: {
                    status = authorizer.checkInstanceAdminAuthorization(sessionToken);
                    break;
                }
                case SPACE_POWER_USER: {
                    status = authorizer.checkSpacePowerUserAuthorization(sessionToken);
                    break;
                }
                default: {
                    status = Status.OK;
                }
            }
            if (status.isError()) {
                authorizationLog.info((Object)String.format("[SESSION:'%s']: Authorization failure while invoking method '%s', user has not " + (Object)((Object)level) + " privilege.", sessionToken, MethodUtils.describeMethod(method)));
                String errorMessage = "You have not " + (Object)((Object)level) + " privilege.";
                if (status.tryGetErrorMessage() != null) {
                    errorMessage = status.tryGetErrorMessage();
                }
                throw new AuthorizationFailureException(errorMessage);
            }
            return level;
        }

        private List<String> getDataSetCodes(AnnotationUtils.Parameter<AuthorizationGuard> param, Object guarded) {
            IAuthorizationGuardPredicate<?, ?> predicate = this.createPredicate(param);
            return predicate.getDataSetCodes(guarded);
        }

        private Status evaluateGuard(String sessionToken, Object recv, AnnotationUtils.Parameter<AuthorizationGuard> param, Object guarded) {
            IAuthorizationGuardPredicate<?, ?> predicate = this.createPredicate(param);
            return predicate.evaluate(recv, sessionToken, guarded);
        }

        private IAuthorizationGuardPredicate<?, ?> createPredicate(AnnotationUtils.Parameter<AuthorizationGuard> param) {
            Class<? extends IAuthorizationGuardPredicate<?, ?>> predicateClass = param.getAnnotation().guardClass();
            return ClassUtils.createInstance(predicateClass);
        }

        private static String getSessionToken(Object[] args) {
            int len = args.length;
            assert (len > 0) : "The session token should be the first argument.";
            Object firstObject = args[0];
            assert (firstObject instanceof String) : "The session token should be the first argument.";
            return (String)firstObject;
        }

        private IShareIdManager getShareIdManager() {
            if (this.shareIdManager == null) {
                this.shareIdManager = ServiceProvider.getShareIdManager();
            }
            return this.shareIdManager;
        }
    }

    private static final class InputStreamProxy
    extends InputStream {
        private final InputStream inputStream;
        private final IShareIdManager manager;

        private InputStreamProxy(InputStream inputStream, IShareIdManager manager) {
            this.inputStream = inputStream;
            this.manager = manager;
        }

        @Override
        public void close() throws IOException {
            try {
                this.inputStream.close();
            }
            finally {
                this.manager.releaseLocks();
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.inputStream.read(b);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }
}

