/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractTabularDataGraphServlet;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CsvFileReaderHelper;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class FileTabularDataGraphServlet
extends AbstractTabularDataGraphServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected ITabularData getDatasetLines(HttpServletRequest request, String dataSetCode, String pathOrNull) throws IOException {
        if (pathOrNull == null) {
            throw new UserFailureException("No value for the parameter file found in the URL");
        }
        AbstractTabularDataGraphServlet.RequestParams requestParams = new AbstractTabularDataGraphServlet.RequestParams(request);
        IHierarchicalContent content = null;
        try {
            DatasetFileLines data;
            File file;
            if (dataSetCode == null) {
                file = new File(pathOrNull);
            } else {
                IHierarchicalContentProvider contentProvider = this.applicationContext.getHierarchicalContentProvider(requestParams.getSessionId());
                content = contentProvider.asContent(dataSetCode);
                IHierarchicalContentNode node = content.getNode(pathOrNull);
                file = node.getFile();
            }
            DatasetFileLines datasetFileLines = data = CsvFileReaderHelper.getDatasetFileLines(file, this.getConfiguration(request));
            return datasetFileLines;
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }
}

