/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.DatasetAcquiredImagesReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageGenerationDescription;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

class ImageGenerationDescriptionFactory {
    ImageGenerationDescriptionFactory() {
    }

    public static String getSessionId(HttpServletRequest request) {
        return ImageGenerationDescriptionFactory.getParam(request, "sessionID");
    }

    public static ImageGenerationDescription create(HttpServletRequest request) {
        String sessionId = ImageGenerationDescriptionFactory.getSessionId(request);
        Size thumbnailSizeOrNull = ImageGenerationDescriptionFactory.tryGetSize(request);
        ImageChannelStackReference channelStackReference = ImageGenerationDescriptionFactory.getImageChannelStackReference(request);
        DatasetAcquiredImagesReference channelsToMerge = ImageGenerationDescriptionFactory.tryGetChannelsToMerge(request, channelStackReference);
        List<DatasetAcquiredImagesReference> overlayChannels = ImageGenerationDescriptionFactory.getOverlayChannels(request, channelStackReference);
        if (channelsToMerge == null && overlayChannels.size() == 0) {
            throw new UserFailureException("Neither channels nor segmentation objects have been specified!");
        }
        String singleChannelTransformationCodeOrNull = request.getParameter("transformation");
        Map<String, String> transformationsPerChannel = ImageGenerationDescriptionFactory.extractTransformationsPerChannel(request);
        return new ImageGenerationDescription(channelsToMerge, singleChannelTransformationCodeOrNull, transformationsPerChannel, overlayChannels, sessionId, thumbnailSizeOrNull);
    }

    private static Map<String, String> extractTransformationsPerChannel(HttpServletRequest request) {
        HashMap<String, String> transformationsPerChannel = new HashMap<String, String>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            if (!paramName.startsWith("transformation") || paramName.equals("transformation")) continue;
            String channelCode = paramName.substring("transformation".length());
            String transformationCode = request.getParameter(paramName);
            if (!StringUtils.isNotBlank(transformationCode)) continue;
            transformationsPerChannel.put(channelCode, transformationCode);
        }
        return transformationsPerChannel;
    }

    private static List<DatasetAcquiredImagesReference> getOverlayChannels(HttpServletRequest request, ImageChannelStackReference channelStackReference) {
        ArrayList<DatasetAcquiredImagesReference> overlayChannels = new ArrayList<DatasetAcquiredImagesReference>();
        Map<String, List<String>> datasetToChannelsMap = ImageGenerationDescriptionFactory.createDatasetToChannelsMap(request);
        for (Map.Entry<String, List<String>> entry : datasetToChannelsMap.entrySet()) {
            String datasetCode = entry.getKey();
            List<String> channels = entry.getValue();
            overlayChannels.add(DatasetAcquiredImagesReference.createForManyChannels(datasetCode, channelStackReference, channels));
        }
        return overlayChannels;
    }

    private static Map<String, List<String>> createDatasetToChannelsMap(HttpServletRequest request) {
        HashMap<String, List<String>> datasetToChannelsMap = new HashMap<String, List<String>>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            if (!paramName.startsWith("overlayChannel-")) continue;
            String datasetCode = paramName.substring("overlayChannel-".length());
            List<String> channelCodes = ImageGenerationDescriptionFactory.tryGetParams(request, paramName);
            if (channelCodes == null) continue;
            datasetToChannelsMap.put(datasetCode, channelCodes);
        }
        return datasetToChannelsMap;
    }

    private static Size tryGetSize(HttpServletRequest request) {
        String displayModeText = request.getParameter("mode");
        String displayMode = displayModeText == null ? "" : displayModeText;
        Size thumbnailSizeOrNull = AbstractDatasetDownloadServlet.tryAsThumbnailDisplayMode(displayMode);
        return thumbnailSizeOrNull;
    }

    private static DatasetAcquiredImagesReference tryGetChannelsToMerge(HttpServletRequest request, ImageChannelStackReference channelStackReference) {
        boolean isMergedChannels = ImageGenerationDescriptionFactory.isMergedChannels(request);
        String datasetCode = request.getParameter("dataset");
        if (datasetCode == null) {
            return null;
        }
        if (!isMergedChannels) {
            List<String> channelsOrNull = ImageGenerationDescriptionFactory.tryGetParams(request, "channel");
            if (channelsOrNull == null) {
                return null;
            }
            if (channelsOrNull.size() > 1) {
                return DatasetAcquiredImagesReference.createForManyChannels(datasetCode, channelStackReference, channelsOrNull);
            }
            String channelCode = channelsOrNull.get(0);
            return DatasetAcquiredImagesReference.createForSingleChannel(datasetCode, channelStackReference, channelCode);
        }
        return DatasetAcquiredImagesReference.createForMergedChannels(datasetCode, channelStackReference);
    }

    private static boolean isMergedChannels(HttpServletRequest request) {
        String mergeChannelsTextOrNull = request.getParameter("mergeChannels");
        boolean isMergedChannels = mergeChannelsTextOrNull != null && mergeChannelsTextOrNull.equalsIgnoreCase("true");
        return isMergedChannels;
    }

    private static ImageChannelStackReference getImageChannelStackReference(HttpServletRequest request) {
        Integer channelStackId = ImageGenerationDescriptionFactory.tryGetIntParam(request, "channelStackId");
        if (channelStackId == null) {
            int tileRow = ImageGenerationDescriptionFactory.getIntParam(request, "tileRow");
            int tileCol = ImageGenerationDescriptionFactory.getIntParam(request, "tileCol");
            Location tileLocation = new Location(tileCol, tileRow);
            Integer wellRow = ImageGenerationDescriptionFactory.tryGetIntParam(request, "wellRow");
            Integer wellCol = ImageGenerationDescriptionFactory.tryGetIntParam(request, "wellCol");
            if (wellRow != null && wellCol != null) {
                Location wellLocation = new Location(wellCol, wellRow);
                return ImageChannelStackReference.createHCSFromLocations(wellLocation, tileLocation);
            }
            if (wellRow == null && wellCol == null) {
                return ImageChannelStackReference.createMicroscopyFromLocations(tileLocation);
            }
            throw new UserFailureException("well reference is not complete, row and column must be specified!");
        }
        return ImageChannelStackReference.createFromId(channelStackId.intValue());
    }

    private static int getIntParam(HttpServletRequest request, String paramName) {
        Integer value = ImageGenerationDescriptionFactory.tryGetIntParam(request, paramName);
        if (value == null) {
            throw new UserFailureException("parameter " + paramName + " should be an integer, but is: " + value);
        }
        return value;
    }

    private static Integer tryGetIntParam(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String getParam(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        if (value == null) {
            throw new UserFailureException("no value for the parameter " + paramName + " found in the URL");
        }
        return value;
    }

    private static List<String> tryGetParams(HttpServletRequest request, String paramName) {
        String[] values = request.getParameterValues(paramName);
        if (values == null || values.length == 0) {
            return null;
        }
        return Arrays.asList(values);
    }
}

