/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class MetaDataBuilder {
    private static final String DATA_SET = "data_set";
    private static final String SAMPLE = "sample";
    private static final String EXPERIMENT = "experiment";
    private static final char DELIM = '\t';
    private static final DateFormat DATE_FORMAT_PATTERN = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static final Comparator<AbstractExternalData> DATA_SET_COMPARATOR = new Comparator<AbstractExternalData>(){

        @Override
        public int compare(AbstractExternalData d1, AbstractExternalData d2) {
            return d1.getCode().compareTo(d2.getCode());
        }
    };
    private static final Comparator<IEntityProperty> PROPERTIES_COMPARATOR = new Comparator<IEntityProperty>(){

        @Override
        public int compare(IEntityProperty p1, IEntityProperty p2) {
            return p1.getPropertyType().getCode().compareTo(p2.getPropertyType().getCode());
        }
    };
    private final StringBuilder builder = new StringBuilder();
    private final String prefix;

    public static String createMetaData(AbstractExternalData dataSet) {
        StringBuilder builder = new StringBuilder();
        builder.append(MetaDataBuilder.createMetData("", dataSet));
        ContainerDataSet containerDataSet = dataSet.tryGetContainer();
        if (containerDataSet != null) {
            builder.append(MetaDataBuilder.createMetData("container[0].", containerDataSet));
        }
        return builder.toString();
    }

    private static String createMetData(String prefix, AbstractExternalData dataSet) {
        MetaDataBuilder builder = new MetaDataBuilder(prefix);
        builder.dataSet("code", dataSet.getCode());
        builder.dataSet("production_timestamp", dataSet.getProductionDate());
        builder.dataSet("producer_code", dataSet.getDataProducerCode());
        builder.dataSet("data_set_type", dataSet.getDataSetType().getCode());
        builder.dataSet("is_measured", !dataSet.isDerived());
        if (dataSet.tryGetAsDataSet() != null) {
            Boolean completeFlag = dataSet.tryGetAsDataSet().getComplete();
            builder.dataSet("is_complete", BooleanOrUnknown.T.equals(completeFlag));
        }
        builder.dataSetProperties(dataSet.getProperties());
        StringBuilder stringBuilder = new StringBuilder();
        List<AbstractExternalData> parents = MetaDataBuilder.getParents(dataSet);
        if (!parents.isEmpty()) {
            Collections.sort(parents, DATA_SET_COMPARATOR);
            for (AbstractExternalData parent : parents) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(parent.getCode());
            }
        }
        builder.dataSet("parent_codes", stringBuilder.toString());
        Sample sample = dataSet.getSample();
        if (sample != null) {
            builder.sample("type_code", sample.getSampleType().getCode());
            builder.sample("code", sample.getCode());
            Space space = sample.getSpace();
            builder.sample("space_code", space == null ? "(shared)" : space.getCode());
            builder.sample("registration_timestamp", sample.getRegistrationDate());
            builder.sample("registrator", sample.getRegistrator());
            builder.sampleProperties(sample.getProperties());
        }
        Experiment experiment = dataSet.getExperiment();
        Project project = experiment.getProject();
        builder.experiment("space_code", project.getSpace().getCode());
        builder.experiment("project_code", project.getCode());
        builder.experiment("experiment_code", experiment.getCode());
        builder.experiment("experiment_type_code", experiment.getExperimentType().getCode());
        builder.experiment("registration_timestamp", experiment.getRegistrationDate());
        builder.experiment("registrator", experiment.getRegistrator());
        builder.experimentProperties(experiment.getProperties());
        return builder.getRenderedMetaData();
    }

    private static List<AbstractExternalData> getParents(AbstractExternalData dataSet) {
        Collection<AbstractExternalData> parents = dataSet.getParents();
        return parents == null ? new ArrayList<AbstractExternalData>() : new ArrayList<AbstractExternalData>(parents);
    }

    private MetaDataBuilder(String prefix) {
        this.prefix = prefix;
    }

    private void dataSetProperties(List<IEntityProperty> properties) {
        this.addProperties(DATA_SET, properties);
    }

    private void sampleProperties(List<IEntityProperty> properties) {
        this.addProperties(SAMPLE, properties);
    }

    private void experimentProperties(List<IEntityProperty> properties) {
        this.addProperties(EXPERIMENT, properties);
    }

    private void addProperties(String category, List<IEntityProperty> properties) {
        if (properties == null) {
            return;
        }
        Collections.sort(properties, PROPERTIES_COMPARATOR);
        for (IEntityProperty property : properties) {
            this.addRow(category, property.getPropertyType().getCode(), property.tryGetAsString());
        }
    }

    private void dataSet(String key, String value) {
        this.addRow(DATA_SET, key, value);
    }

    private void dataSet(String key, Date date) {
        this.addRow(DATA_SET, key, date);
    }

    private void dataSet(String key, boolean flag) {
        this.addRow(DATA_SET, key, flag);
    }

    private void sample(String key, String value) {
        this.addRow(SAMPLE, key, value);
    }

    private void sample(String key, Person person) {
        this.addRow(SAMPLE, key, person);
    }

    private void sample(String key, Date date) {
        this.addRow(SAMPLE, key, date);
    }

    private void experiment(String key, String value) {
        this.addRow(EXPERIMENT, key, value);
    }

    private void experiment(String key, Person person) {
        this.addRow(EXPERIMENT, key, person);
    }

    private void experiment(String key, Date date) {
        this.addRow(EXPERIMENT, key, date);
    }

    private void addRow(String category, String key, Person person) {
        StringBuilder stringBuilder = new StringBuilder();
        if (person != null) {
            String firstName = person.getFirstName();
            String lastName = person.getLastName();
            if (firstName != null && lastName != null) {
                stringBuilder.append(firstName).append(' ').append(lastName);
            } else {
                stringBuilder.append(person.getUserId());
            }
            String email = person.getEmail();
            if (email != null) {
                stringBuilder.append(" <").append(email).append(">");
            }
        }
        this.addRow(category, key, stringBuilder.toString());
    }

    private void addRow(String category, String key, Date date) {
        this.addRow(category, key, date == null ? null : DATE_FORMAT_PATTERN.format(date));
    }

    private void addRow(String category, String key, boolean flag) {
        this.addRow(category, key, Boolean.valueOf(flag).toString().toUpperCase());
    }

    private void addRow(String category, String key, String value) {
        this.builder.append(this.prefix).append(category).append('\t').append(key).append('\t');
        this.builder.append(value == null ? "" : value).append('\n');
    }

    private String getRenderedMetaData() {
        return this.builder.toString();
    }
}

