/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.FilenameUtils;

public class Utils {
    public static final String SESSION_ID_PARAM = "sessionID";
    static final String BINARY_CONTENT_TYPE = "binary";
    static final String PLAIN_TEXT_CONTENT_TYPE = "text/plain";
    static final MimetypesFileTypeMap MIMETYPES = new MimetypesFileTypeMap();
    static final String CONTENT_TYPE_PNG = "image/png";

    static {
        MIMETYPES.addMimeTypes("application/pdf pdf");
        MIMETYPES.addMimeTypes("image/svg+xml svg");
        MIMETYPES.addMimeTypes("video/webm webm");
        MIMETYPES.addMimeTypes("video/mp4 mp4");
        MIMETYPES.addMimeTypes("text/css css");
        MIMETYPES.addMimeTypes("text/javascript js");
    }

    static String createUrlParameterForSessionId(String prefix, String sessionIdOrNull) {
        return sessionIdOrNull == null ? "" : String.valueOf(prefix) + SESSION_ID_PARAM + "=" + sessionIdOrNull;
    }

    static String getMimeType(IHierarchicalContentNode fileNode, boolean plainTextMode) {
        return Utils.getMimeType(fileNode.getName(), plainTextMode);
    }

    static String getMimeType(String fileName, boolean plainTextMode) {
        if (plainTextMode) {
            return BINARY_CONTENT_TYPE;
        }
        String extension = FilenameUtils.getExtension((String)fileName);
        if (extension.length() == 0) {
            return PLAIN_TEXT_CONTENT_TYPE;
        }
        if (extension.equalsIgnoreCase("png")) {
            return CONTENT_TYPE_PNG;
        }
        return MIMETYPES.getContentType(fileName.toLowerCase());
    }
}

