/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class FtpPathResolverContext
implements ISessionTokenProvider {
    private final String sessionToken;
    private final IServiceForDataStoreServer service;
    private final IGeneralInformationService generalInfoService;
    private final IFtpPathResolverRegistry resolverRegistry;
    private final Cache cache;

    public FtpPathResolverContext(String sessionToken, IServiceForDataStoreServer service, IGeneralInformationService generalInfoService, IFtpPathResolverRegistry resolverRegistry, Cache cache) {
        this.sessionToken = sessionToken;
        this.service = service;
        this.generalInfoService = generalInfoService;
        this.resolverRegistry = resolverRegistry;
        this.cache = cache;
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    public IServiceForDataStoreServer getService() {
        return this.service;
    }

    public DataSet getDataSet(String dataSetCode) {
        DataSet dataSet = this.cache.getDataSet(dataSetCode);
        if (dataSet == null) {
            EnumSet<DataSetFetchOption> fetchOptions = EnumSet.of(DataSetFetchOption.BASIC, DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN);
            List<DataSet> dataSetsWithMetaData = this.generalInfoService.getDataSetMetaData(this.sessionToken, Arrays.asList(dataSetCode), fetchOptions);
            dataSet = dataSetsWithMetaData.get(0);
            this.cache.putDataSet(dataSet);
        }
        return dataSet;
    }

    public List<AbstractExternalData> listDataSetsByCode(List<String> codes) {
        ArrayList<String> codesToAskFor = new ArrayList<String>();
        ArrayList<AbstractExternalData> dataSets = new ArrayList<AbstractExternalData>();
        for (String code : codes) {
            AbstractExternalData dataSet = this.cache.getExternalData(code);
            if (dataSet == null) {
                codesToAskFor.add(code);
                continue;
            }
            dataSets.add(dataSet);
        }
        if (!codesToAskFor.isEmpty()) {
            List<AbstractExternalData> newDataSets = this.service.listDataSetsByCode(this.sessionToken, codesToAskFor);
            for (AbstractExternalData newDataSet : newDataSets) {
                this.cache.putExternalData(newDataSet);
                dataSets.add(newDataSet);
            }
        }
        return dataSets;
    }

    public Experiment getExperiment(String experimentId) {
        Experiment experiment = this.cache.getExperiment(experimentId);
        if (experiment == null) {
            ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(experimentId).createIdentifier();
            List<Experiment> result = this.service.listExperiments(this.sessionToken, Collections.singletonList(experimentIdentifier), new ExperimentFetchOptions());
            Experiment experiment2 = experiment = result.isEmpty() ? null : result.get(0);
            if (experiment != null) {
                this.cache.putExperiment(experiment);
            }
        }
        return experiment;
    }

    public IGeneralInformationService getGeneralInfoService() {
        return this.generalInfoService;
    }

    public IFtpPathResolverRegistry getResolverRegistry() {
        return this.resolverRegistry;
    }
}

