/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.DSSFileSystemView;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpServerConfig;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpUser;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.io.IOUtils;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.DefaultFtplet;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.log4j.Logger;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;

public class FtpServer
implements org.apache.ftpserver.ftplet.FileSystemFactory,
FileSystemFactory {
    private static final Session.AttributeKey<User> USER_KEY = new Session.AttributeKey();
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FtpServer.class);
    private final IServiceForDataStoreServer openBisService;
    private final UserManager userManager;
    private final FtpServerConfig config;
    private final IFtpPathResolverRegistry pathResolverRegistry;
    private org.apache.ftpserver.FtpServer server;
    private final IGeneralInformationService generalInfoService;
    private SshServer sshServer;

    public FtpServer(IServiceForDataStoreServer openBisService, IGeneralInformationService generalInfoService, UserManager userManager) throws Exception {
        this.openBisService = openBisService;
        this.generalInfoService = generalInfoService;
        this.userManager = userManager;
        this.config = new FtpServerConfig(DssPropertyParametersUtil.loadServiceProperties());
        this.pathResolverRegistry = new FtpPathResolverRegistry(this.config);
        if (this.config.isStartServer()) {
            this.config.logStartupInfo();
            this.start();
        }
    }

    private void start() throws Exception {
        if (this.config.isSftpMode()) {
            this.sshServer = this.createSftpServer();
            operationLog.info((Object)String.format("Starting SFTP server on port %d ...", this.config.getSftpPort()));
            this.sshServer.start();
            operationLog.info((Object)"SFTP server started.");
        }
        if (this.config.isFtpMode()) {
            this.server = this.createFtpServer();
            operationLog.info((Object)String.format("Starting FTP server on port %d ...", this.config.getFtpPort()));
            this.server.start();
            operationLog.info((Object)"FTP server started.");
        }
    }

    private org.apache.ftpserver.FtpServer createFtpServer() {
        FtpServerFactory serverFactory = new FtpServerFactory();
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(this.config.getFtpPort());
        if (this.config.isUseSSL()) {
            SslConfigurationFactory sslConfigFactory = new SslConfigurationFactory();
            sslConfigFactory.setKeystoreFile(this.config.getKeyStore());
            sslConfigFactory.setKeystorePassword(this.config.getKeyStorePassword());
            sslConfigFactory.setKeyPassword(this.config.getKeyPassword());
            factory.setSslConfiguration(sslConfigFactory.createSslConfiguration());
            factory.setImplicitSsl(this.config.isImplicitSSL());
            serverFactory.setFtplets(Collections.singletonMap("", new DefaultFtplet(){

                public FtpletResult beforeCommand(FtpSession session, FtpRequest request) throws FtpException, IOException {
                    String cmd = request.getCommand().toUpperCase();
                    if ("USER".equals(cmd) && !session.isSecure()) {
                        session.write((FtpReply)new DefaultFtpReply(500, "Control channel is not secure. Please, issue AUTH command first."));
                        return FtpletResult.SKIP;
                    }
                    return super.beforeCommand(session, request);
                }
            }));
        }
        DataConnectionConfigurationFactory dccFactory = new DataConnectionConfigurationFactory();
        dccFactory.setPassivePorts(this.config.getPassivePortsRange());
        if (this.config.isActiveModeEnabled()) {
            dccFactory.setActiveEnabled(true);
            dccFactory.setActiveLocalPort(this.config.getActiveLocalPort());
        }
        factory.setDataConnectionConfiguration(dccFactory.createDataConnectionConfiguration());
        serverFactory.addListener("default", factory.createListener());
        ConnectionConfigFactory connectionConfigFactory = new ConnectionConfigFactory();
        connectionConfigFactory.setMaxThreads(this.config.getMaxThreads().intValue());
        serverFactory.setConnectionConfig(connectionConfigFactory.createConnectionConfig());
        serverFactory.setFileSystem((org.apache.ftpserver.ftplet.FileSystemFactory)this);
        serverFactory.setUserManager(this.userManager);
        return serverFactory.createServer();
    }

    private SshServer createSftpServer() {
        SshServer s = SshServer.setUpDefaultServer();
        KeystoreBasedKeyPairProvider keyPairProvider = new KeystoreBasedKeyPairProvider(this.config, operationLog);
        s.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        s.setPort(this.config.getSftpPort());
        s.setSubsystemFactories(this.creatSubsystemFactories());
        s.setFileSystemFactory((FileSystemFactory)this);
        s.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                try {
                    UsernamePasswordAuthentication authentication = new UsernamePasswordAuthentication(username, password);
                    User user = FtpServer.this.userManager.authenticate((Authentication)authentication);
                    session.setAttribute(USER_KEY, (Object)user);
                    return true;
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    return false;
                }
            }
        });
        return s;
    }

    private List<NamedFactory<Command>> creatSubsystemFactories() {
        return Arrays.asList(new SftpSubsystem.Factory());
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.sshServer != null) {
            try {
                this.sshServer.stop();
            }
            catch (InterruptedException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }

    public DSSFileSystemView createFileSystemView(User user) throws FtpException {
        if (user instanceof FtpUser) {
            String sessionToken = ((FtpUser)user).getSessionToken();
            return new DSSFileSystemView(sessionToken, this.openBisService, this.generalInfoService, this.pathResolverRegistry);
        }
        throw new FtpException("Unsupported user type.");
    }

    public FileSystemView createFileSystemView(Session session) throws IOException {
        User user = (User)session.getAttribute(USER_KEY);
        try {
            final DSSFileSystemView view = this.createFileSystemView(user);
            return new FileSystemView(){
                private Cache cache = new Cache(SystemTimeProvider.SYSTEM_TIME_PROVIDER);

                public SshFile getFile(SshFile baseDir, String file) {
                    throw new UnsupportedOperationException();
                }

                public SshFile getFile(String file) {
                    return new FileView(view, file, this.cache);
                }
            };
        }
        catch (FtpException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private static final class FileView
    implements SshFile {
        private final DSSFileSystemView fileView;
        private final String path;
        private final List<InputStream> inputStreams = new ArrayList<InputStream>();
        private FtpFile file;
        private final Cache cache;

        FileView(DSSFileSystemView fileView, String path, Cache cache) {
            this.fileView = fileView;
            this.path = path;
            this.cache = cache;
        }

        private FtpFile getFile() {
            if (this.file == null) {
                try {
                    this.file = this.fileView.getFile(this.path, this.cache);
                }
                catch (FtpException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
                }
            }
            return this.file;
        }

        public String getAbsolutePath() {
            return this.getFile().getAbsolutePath();
        }

        public String getName() {
            return FileUtilities.getFileNameFromRelativePath(this.path);
        }

        public boolean isDirectory() {
            return this.getFile().isDirectory();
        }

        public boolean isFile() {
            return this.getFile().isFile();
        }

        public boolean doesExist() {
            return this.getFile().doesExist();
        }

        public boolean isReadable() {
            return this.getFile().isReadable();
        }

        public boolean isWritable() {
            return false;
        }

        public boolean isExecutable() {
            return false;
        }

        public boolean isRemovable() {
            return this.getFile().isRemovable();
        }

        public SshFile getParentFile() {
            return null;
        }

        public long getLastModified() {
            return this.getFile().getLastModified();
        }

        public boolean setLastModified(long time) {
            return false;
        }

        public long getSize() {
            return this.getFile().getSize();
        }

        public boolean mkdir() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public boolean create() throws IOException {
            return false;
        }

        public void truncate() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean move(SshFile destination) {
            return false;
        }

        public List<SshFile> listSshFiles() {
            List files = this.getFile().listFiles();
            ArrayList<SshFile> result = new ArrayList<SshFile>();
            for (FtpFile child : files) {
                result.add(new FileView(this.fileView, child.getAbsolutePath(), this.cache));
            }
            return result;
        }

        public OutputStream createOutputStream(long offset) throws IOException {
            throw new UnsupportedOperationException();
        }

        public InputStream createInputStream(long offset) throws IOException {
            InputStream inputStream = this.getFile().createInputStream(offset);
            this.inputStreams.add(inputStream);
            return inputStream;
        }

        public void handleClose() throws IOException {
            for (InputStream inputStream : this.inputStreams) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            this.inputStreams.clear();
        }

        public String getOwner() {
            return "openBIS";
        }
    }

    private static final class KeystoreBasedKeyPairProvider
    extends AbstractKeyPairProvider {
        private final KeyPair[] keyPairs;

        private KeystoreBasedKeyPairProvider(FtpServerConfig config, Logger operationLog) {
            File keyStoreFile = config.getKeyStore();
            String keyStorePassword = config.getKeyStorePassword();
            String keyPassword = config.getKeyPassword();
            KeyStore keystore = this.loadKeystore(keyStoreFile, keyStorePassword);
            X509ExtendedKeyManager keyManager = this.getKeyManager(keystore, keyStorePassword, keyPassword);
            ArrayList<KeyPair> list = new ArrayList<KeyPair>();
            try {
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!keystore.isKeyEntry(alias)) continue;
                    Certificate certificate = keystore.getCertificate(alias);
                    PublicKey publicKey = certificate.getPublicKey();
                    PrivateKey privateKey = keyManager.getPrivateKey(alias);
                    list.add(new KeyPair(publicKey, privateKey));
                }
                this.keyPairs = list.toArray(new KeyPair[list.size()]);
                operationLog.info((Object)(String.valueOf(this.keyPairs.length) + " key pairs loaded from keystore " + keyStoreFile));
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }

        protected KeyPair[] loadKeys() {
            return this.keyPairs;
        }

        private KeyStore loadKeystore(File keyStoreFile, String keyStorePassword) {
            KeyStore keyStore;
            FileInputStream stream = null;
            try {
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                stream = new FileInputStream(keyStoreFile);
                keystore.load(stream, keyStorePassword.toCharArray());
                keyStore = keystore;
            }
            catch (Exception e) {
                try {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
            return keyStore;
        }

        private X509ExtendedKeyManager getKeyManager(KeyStore keystore, String keyStorePassword, String keyPassword) {
            try {
                String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory factory = KeyManagerFactory.getInstance(defaultAlgorithm);
                char[] password = (keyPassword == null ? keyStorePassword : keyPassword).toCharArray();
                factory.init(keystore, password);
                KeyManager[] keyManagers = factory.getKeyManagers();
                if (keyManagers.length != 1) {
                    throw new ConfigurationFailureException("Only one key manager expected instead of " + keyManagers.length + ".");
                }
                KeyManager keyManager = keyManagers[0];
                if (!(keyManager instanceof X509ExtendedKeyManager)) {
                    throw new ConfigurationFailureException("Key manager is not of type " + X509ExtendedKeyManager.class.getSimpleName() + ": " + keyManager.getClass().getName());
                }
                return (X509ExtendedKeyManager)keyManager;
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }
}

