/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FtpFileEvaluationContext {
    private Map<String, IHierarchicalContent> contents = new HashMap<String, IHierarchicalContent>();
    private IHierarchicalContentProvider contentProvider;
    private List<EvaluatedElement> evaluatedPaths = new ArrayList<EvaluatedElement>();

    FtpFileEvaluationContext(IHierarchicalContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public List<EvaluatedElement> getEvalElements() {
        return Collections.unmodifiableList(this.evaluatedPaths);
    }

    public void addEvaluatedElements(Collection<EvaluatedElement> evaluatedPath) {
        this.evaluatedPaths.addAll(evaluatedPath);
    }

    public IHierarchicalContent getHierarchicalContent(AbstractExternalData dataSet) {
        String dataSetCode = dataSet.getCode();
        IHierarchicalContent result = this.contents.get(dataSetCode);
        if (result == null) {
            result = this.createHierarchicalContent(dataSet);
            this.contents.put(dataSetCode, result);
        }
        return result;
    }

    public void close() {
        for (IHierarchicalContent content : this.contents.values()) {
            content.close();
        }
        this.contents.clear();
    }

    private IHierarchicalContent createHierarchicalContent(AbstractExternalData dataSet) {
        return this.contentProvider.asContent(dataSet);
    }

    static class EvaluatedElement {
        AbstractExternalData dataSet;
        String pathInDataSet = "";
        String evaluatedTemplate;
        IHierarchicalContentNode contentNode;

        EvaluatedElement() {
        }
    }
}

