/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpFileFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;

public class FtpFileImpl
extends AbstractFtpFile {
    private final String dataSetCode;
    private final String pathInDataSet;
    private final boolean isDirectory;
    private final long size;
    private final long lastModified;
    private final IHierarchicalContentNodeFilter childrenFilter;
    private IHierarchicalContent content;

    public FtpFileImpl(String dataSetCode, String path, String pathInDataSet, boolean isDirectory, long size, long lastModified, IHierarchicalContent content, IHierarchicalContentNodeFilter childrenFilter) {
        super(path);
        this.dataSetCode = dataSetCode;
        this.pathInDataSet = pathInDataSet;
        this.isDirectory = isDirectory;
        this.size = size;
        this.lastModified = lastModified;
        this.content = content;
        this.childrenFilter = childrenFilter;
    }

    public InputStream createInputStream(long offset) throws IOException {
        try {
            IHierarchicalContentNode contentNode = this.getContentNodeForThisFile();
            InputStream result = HierarchicalContentUtils.getInputStreamAutoClosingContent(contentNode, this.content);
            if (offset > 0L) {
                result.skip(offset);
            }
            return result;
        }
        catch (IOException ioex) {
            this.content.close();
            throw ioex;
        }
        catch (RuntimeException re) {
            this.content.close();
            throw re;
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getSize() {
        if (this.isFile()) {
            return this.size;
        }
        return 0L;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public List<FtpFile> unsafeListFiles() {
        if (this.isFile()) {
            throw new UnsupportedOperationException();
        }
        try {
            IHierarchicalContentNode contentNode = this.getContentNodeForThisFile();
            List<IHierarchicalContentNode> children = contentNode.getChildNodes();
            ArrayList<FtpFile> result = new ArrayList<FtpFile>();
            for (IHierarchicalContentNode childNode : children) {
                if (!this.childrenFilter.accept(childNode)) continue;
                String childPath = String.valueOf(this.absolutePath) + "/" + childNode.getName();
                FtpFile childFile = FtpFileFactory.createFtpFile(this.dataSetCode, childPath, childNode, this.content, this.childrenFilter);
                result.add(childFile);
            }
            ArrayList<FtpFile> arrayList = result;
            return arrayList;
        }
        finally {
            this.content.close();
        }
    }

    private IHierarchicalContentNode getContentNodeForThisFile() {
        return this.content.getNode(this.pathInDataSet);
    }
}

