/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;

public class SpaceFolderResolver
implements IFtpPathResolver {
    @Override
    public boolean canResolve(String path) {
        return !this.removeStartingSlash(path).contains("/");
    }

    @Override
    public FtpFile resolve(final String path, final FtpPathResolverContext resolverContext) {
        return new AbstractFtpFolder(path){

            @Override
            public List<FtpFile> unsafeListFiles() {
                List projects = SpaceFolderResolver.this.listProjects(resolverContext);
                String pathSpaceCode = SpaceFolderResolver.this.removeStartingSlash(path);
                ArrayList<FtpFile> result = new ArrayList<FtpFile>();
                ArrayList<String> childProjects = new ArrayList<String>();
                for (Project project : projects) {
                    String projectSpaceCode = project.getSpace().getCode();
                    if (!projectSpaceCode.equals(pathSpaceCode)) continue;
                    childProjects.add(project.getCode());
                }
                for (String childProject : childProjects) {
                    String childPath = String.valueOf(path) + "/" + childProject;
                    FtpFile childFile = resolverContext.getResolverRegistry().resolve(childPath, resolverContext);
                    result.add(childFile);
                }
                return result;
            }
        };
    }

    private List<Project> listProjects(FtpPathResolverContext context) {
        IServiceForDataStoreServer service = context.getService();
        String sessionToken = context.getSessionToken();
        List<Project> projects = service.listProjects(sessionToken);
        return projects;
    }

    private String removeStartingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }
}

