/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.ITabularDataGraph;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataGraphConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataHeatmap;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataHeatmapConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataHistogram;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataHistogramConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataScatterplot;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataScatterplotConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CodeAndLabelUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CsvFileReaderHelper;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class TabularDataGraphCollectionConfiguration
implements CsvFileReaderHelper.ICsvFileReaderConfiguration {
    private static final String CODE_POSTFIX = ".code";
    private static final String LABEL_POSTFIX = ".label";
    public static final String SEPARATOR_PROPERTY_KEY = "separator";
    private static final String IGNORE_COMMENTS_PROPERTY_KEY = "ignore-comments";
    private static final String IMAGE_WIDTH_KEY = "full-width";
    private static final String IMAGE_HEIGHT_KEY = "full-height";
    private static final String THUMBNAIL_WIDTH_KEY = "column-width";
    private static final String THUMBNAIL_HEIGHT_KEY = "column-height";
    public static final String GRAPHS_KEY = "graphs";
    public static final String GRAPHS_TYPES_KEY = "graph-type";
    public static final String TITLE_KEY = "title";
    public static final String X_AXIS_KEY = "x-axis";
    public static final String Y_AXIS_KEY = "y-axis";
    public static final String COLUMN_KEY = "column";
    public static final String NUMBER_OF_BINS_KEY = "number-of-bins";
    private final char columnDelimiter;
    private final boolean ignoreComments;
    private final char comment = (char)35;
    private final int imageWidth;
    private final int imageHeight;
    private final int thumbnailWidth;
    private final int thumbnailHeight;
    private final ArrayList<String> graphNames;
    private final HashMap<String, TabularDataGraphConfiguration> graphTypeMap;

    public static TabularDataGraphCollectionConfiguration getConfiguration(String path) throws EnvironmentFailureException {
        Properties configurationProps = new Properties();
        try {
            configurationProps.load(new FileInputStream(path));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EnvironmentFailureException("Could not find the configuration file " + new File(path).getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new EnvironmentFailureException("Could not read the configuration file " + path);
        }
        return new TabularDataGraphCollectionConfiguration(configurationProps);
    }

    public static TabularDataGraphCollectionConfiguration getConfiguration(DynamicTabularDataGraphCollectionConfiguration config) throws EnvironmentFailureException {
        return new TabularDataGraphCollectionConfiguration(config);
    }

    private TabularDataGraphCollectionConfiguration(Properties properties) {
        this.columnDelimiter = PropertyUtils.getChar(properties, SEPARATOR_PROPERTY_KEY, ',');
        this.ignoreComments = PropertyUtils.getBoolean(properties, IGNORE_COMMENTS_PROPERTY_KEY, true);
        this.imageWidth = PropertyUtils.getInt(properties, IMAGE_WIDTH_KEY, 800);
        this.imageHeight = PropertyUtils.getInt(properties, IMAGE_HEIGHT_KEY, 600);
        this.thumbnailWidth = PropertyUtils.getInt(properties, THUMBNAIL_WIDTH_KEY, 300);
        this.thumbnailHeight = PropertyUtils.getInt(properties, THUMBNAIL_HEIGHT_KEY, 200);
        this.graphNames = new ArrayList();
        this.initializeGraphTypeCodes(properties);
        this.graphTypeMap = new HashMap();
        this.initialzeGraphTypeMap(properties);
    }

    private TabularDataGraphCollectionConfiguration(DynamicTabularDataGraphCollectionConfiguration config) {
        this.columnDelimiter = config.getColumnDelimiter();
        this.ignoreComments = config.isIgnoreComments();
        this.imageWidth = config.getImageWidth();
        this.imageHeight = config.getImageHeight();
        this.thumbnailWidth = config.getThumbnailWidth();
        this.thumbnailHeight = config.getThumbnailHeight();
        this.graphNames = new ArrayList();
        this.graphNames.add(DynamicTabularDataGraphCollectionConfiguration.DYNAMIC_GRAPH_NAME);
        this.graphTypeMap = new HashMap();
        this.initialzeGraphTypeMap(config.getProperties());
    }

    private void initializeGraphTypeCodes(Properties properties) {
        String[] typeCodeArray;
        String graphTypeCodesString = properties.getProperty(GRAPHS_KEY, "");
        String[] stringArray = typeCodeArray = graphTypeCodesString.split(",");
        int n = typeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String typeCode = stringArray[n2];
            this.graphNames.add(typeCode.trim());
            ++n2;
        }
    }

    private void initialzeGraphTypeMap(Properties properties) {
        PropertyParametersUtil.SectionProperties[] pluginServicesProperties;
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = pluginServicesProperties = PropertyParametersUtil.extractSectionProperties(properties, GRAPHS_KEY, false);
        int n = pluginServicesProperties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProp = sectionPropertiesArray[n2];
            TabularDataGraphConfiguration config = this.getConfiguration(sectionProp);
            this.graphTypeMap.put(sectionProp.getKey(), config);
            ++n2;
        }
    }

    private TabularDataGraphConfiguration getConfiguration(PropertyParametersUtil.SectionProperties sectionProp) {
        Properties props = sectionProp.getProperties();
        String graphTypeValue = PropertyUtils.getMandatoryProperty(props, GRAPHS_TYPES_KEY);
        TabularDataGraphConfiguration.GraphType type = TabularDataGraphConfiguration.GraphType.valueOf(graphTypeValue.toUpperCase());
        String title = props.getProperty(TITLE_KEY, sectionProp.getKey());
        switch (type) {
            case HEATMAP: {
                CodeAndLabel xAxis = this.getCodeAndLabelWithDefault(props, X_AXIS_KEY, "Row");
                CodeAndLabel yAxis = this.getCodeAndLabelWithDefault(props, Y_AXIS_KEY, "Column");
                CodeAndLabel zAxis = this.getCodeAndLabel(props, COLUMN_KEY);
                if (xAxis.equals(yAxis)) {
                    return new TabularDataHeatmapConfiguration(title, xAxis, zAxis, this.getThumbnailWidth(), this.getThumbnailHeight());
                }
                return new TabularDataHeatmapConfiguration(title, xAxis, yAxis, zAxis, this.getThumbnailWidth(), this.getThumbnailHeight());
            }
            case HISTOGRAM: {
                return new TabularDataHistogramConfiguration(title, this.getCodeAndLabel(props, COLUMN_KEY), this.getThumbnailWidth(), this.getThumbnailHeight(), PropertyUtils.getInt(props, NUMBER_OF_BINS_KEY, 10));
            }
            case SCATTERPLOT: {
                CodeAndLabel xAxis = this.getCodeAndLabel(props, X_AXIS_KEY);
                CodeAndLabel yAxis = this.getCodeAndLabel(props, Y_AXIS_KEY);
                return new TabularDataScatterplotConfiguration(title, xAxis, yAxis, this.getThumbnailWidth(), this.getThumbnailHeight());
            }
        }
        return null;
    }

    private CodeAndLabel getCodeAndLabel(Properties properties, String key) {
        String labelWithOptionalCode = properties.getProperty(key);
        if (labelWithOptionalCode != null) {
            return CodeAndLabelUtil.create(labelWithOptionalCode);
        }
        String labelKey = String.valueOf(key) + LABEL_POSTFIX;
        String label = properties.getProperty(labelKey);
        String codeKey = String.valueOf(key) + CODE_POSTFIX;
        String code = properties.getProperty(codeKey);
        if (label == null && code == null) {
            throw new IllegalArgumentException("Missing one of the following properties: " + key + ", " + codeKey + ", " + labelKey);
        }
        if (code == null) {
            return CodeAndLabelUtil.create(label);
        }
        return CodeNormalizer.create(code, label);
    }

    private CodeAndLabel getCodeAndLabelWithDefault(Properties properties, String key, String defaultLabel) {
        String labelWithOptionalCode = properties.getProperty(key);
        if (labelWithOptionalCode != null) {
            return CodeAndLabelUtil.create(labelWithOptionalCode);
        }
        String labelKey = String.valueOf(key) + LABEL_POSTFIX;
        String label = properties.getProperty(labelKey);
        String codeKey = String.valueOf(key) + CODE_POSTFIX;
        String code = properties.getProperty(codeKey);
        if (label == null && code == null) {
            label = defaultLabel;
            code = CodeNormalizer.normalize(label);
        }
        if (code == null) {
            return CodeAndLabelUtil.create(label);
        }
        return CodeNormalizer.create(code, label);
    }

    public TabularDataGraphConfiguration getGraphConfiguration(String graphName) {
        TabularDataGraphConfiguration config = this.graphTypeMap.get(graphName);
        if (config == null) {
            throw new IllegalArgumentException("No graph associated with code " + graphName);
        }
        return config;
    }

    public ITabularDataGraph getGraph(String graphName, ITabularData fileLines, OutputStream out) {
        TabularDataGraphConfiguration config = this.graphTypeMap.get(graphName);
        if (config == null) {
            throw new IllegalArgumentException("No graph associated with code " + graphName);
        }
        TabularDataGraphConfiguration.GraphType type = config.getGraphType();
        switch (type) {
            case HEATMAP: {
                return new TabularDataHeatmap((TabularDataHeatmapConfiguration)config, fileLines, out);
            }
            case HISTOGRAM: {
                return new TabularDataHistogram((TabularDataHistogramConfiguration)config, fileLines, out);
            }
            case SCATTERPLOT: {
                return new TabularDataScatterplot((TabularDataScatterplotConfiguration)config, fileLines, out);
            }
        }
        return null;
    }

    @Override
    public char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    @Override
    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    @Override
    public char getCommentDelimiter() {
        return this.comment;
    }

    @Override
    public boolean isSkipEmptyRecords() {
        return true;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public List<String> getGraphNames() {
        return this.graphNames;
    }

    public static class DynamicTabularDataGraphCollectionConfiguration {
        public static String DYNAMIC_GRAPH_NAME = "dynamic";
        private char columnDelimiter = (char)59;
        private boolean ignoreComments = true;
        private int imageWidth = 800;
        private int imageHeight = 600;
        private int thumbnailWidth = 300;
        private int thumbnailHeight = 200;
        private Properties properties = new Properties();

        public char getColumnDelimiter() {
            return this.columnDelimiter;
        }

        public void setColumnDelimiter(char columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
        }

        public boolean isIgnoreComments() {
            return this.ignoreComments;
        }

        public void setIgnoreComments(boolean ignoreComments) {
            this.ignoreComments = ignoreComments;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public void setImageWidth(int imageWidth) {
            this.imageWidth = imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public void setImageHeight(int imageHeight) {
            this.imageHeight = imageHeight;
        }

        public int getThumbnailWidth() {
            return this.thumbnailWidth;
        }

        public void setThumbnailWidth(int thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
        }

        public int getThumbnailHeight() {
            return this.thumbnailHeight;
        }

        public void setThumbnailHeight(int thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }
    }
}

