/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images.dto;

import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.DatasetAcquiredImagesReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import java.util.List;
import java.util.Map;

public class ImageGenerationDescription {
    private final DatasetAcquiredImagesReference imageChannelsOrNull;
    private final String singleChannelTransformationCodeOrNull;
    private final Map<String, String> transformationsPerChannelOrNull;
    private final List<DatasetAcquiredImagesReference> overlayChannels;
    private final String sessionId;
    private final Size thumbnailSizeOrNull;

    public ImageGenerationDescription(DatasetAcquiredImagesReference imageChannelsOrNull, String singleChannelTransformationCodeOrNull, Map<String, String> transformationsPerChannelOrNull, List<DatasetAcquiredImagesReference> overlayChannels, String sessionId, Size thumbnailSizeOrNull) {
        this.imageChannelsOrNull = imageChannelsOrNull;
        this.singleChannelTransformationCodeOrNull = singleChannelTransformationCodeOrNull;
        this.transformationsPerChannelOrNull = transformationsPerChannelOrNull;
        this.overlayChannels = overlayChannels;
        this.sessionId = sessionId;
        this.thumbnailSizeOrNull = thumbnailSizeOrNull;
    }

    public DatasetAcquiredImagesReference tryGetImageChannels() {
        return this.imageChannelsOrNull;
    }

    public String tryGetSingleChannelTransformationCode() {
        return this.singleChannelTransformationCodeOrNull;
    }

    public Map<String, String> tryGetTransformationsPerChannel() {
        return this.transformationsPerChannelOrNull;
    }

    public List<DatasetAcquiredImagesReference> getOverlayChannels() {
        return this.overlayChannels;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Size tryGetThumbnailSize() {
        return this.thumbnailSizeOrNull;
    }

    public String toString() {
        return "ImageGenerationDescription [image channels=" + this.imageChannelsOrNull + (this.overlayChannels == null || this.overlayChannels.size() == 0 ? "" : ", overlay channels=" + this.overlayChannels) + ", " + (this.thumbnailSizeOrNull == null ? "original size" : "size=" + this.thumbnailSizeOrNull) + "]";
    }

    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("image");
        if (this.imageChannelsOrNull != null) {
            ImageGenerationDescription.appendShortDescription(sb, this.imageChannelsOrNull);
        }
        for (DatasetAcquiredImagesReference overlay : this.overlayChannels) {
            sb.append("_");
            ImageGenerationDescription.appendChannels(sb, overlay);
        }
        if (this.thumbnailSizeOrNull != null) {
            sb.append("_");
            sb.append(this.thumbnailSizeOrNull.getWidth());
            sb.append("x");
            sb.append(this.thumbnailSizeOrNull.getHeight());
        }
        return sb.toString();
    }

    private static void appendShortDescription(StringBuffer sb, DatasetAcquiredImagesReference imagesRef) {
        ImageGenerationDescription.appendChannels(sb, imagesRef);
        ImageGenerationDescription.appendStackRef(sb, imagesRef.getChannelStackReference());
    }

    private static void appendChannels(StringBuffer sb, DatasetAcquiredImagesReference imagesRef) {
        List<String> channelCodes = imagesRef.getChannelCodes(null);
        if (channelCodes == null) {
            sb.append("merged");
        } else {
            for (String channel : channelCodes) {
                sb.append("_");
                sb.append(channel);
            }
        }
    }

    private static void appendStackRef(StringBuffer sb, ImageChannelStackReference stackRef) {
        Long channelStackId;
        ImageChannelStackReference.MicroscopyChannelStackByLocationReference microscopyChannelStack;
        ImageChannelStackReference.HCSChannelStackByLocationReference hcsChannelStack = stackRef.tryGetHCSChannelStack();
        if (hcsChannelStack != null) {
            sb.append("_well");
            sb.append(hcsChannelStack.getWellLocation().createMatrixCoordinateFromLocation());
            ImageGenerationDescription.appendTileLocation(sb, hcsChannelStack.getTileLocation());
        }
        if ((microscopyChannelStack = stackRef.tryGetMicroscopyChannelStack()) != null) {
            ImageGenerationDescription.appendTileLocation(sb, microscopyChannelStack.getTileLocation());
        }
        if ((channelStackId = stackRef.tryGetChannelStackId()) != null) {
            sb.append("_");
            sb.append(channelStackId);
        }
    }

    private static void appendTileLocation(StringBuffer sb, Location tileLocation) {
        sb.append("_tile");
        sb.append(tileLocation.getY());
        sb.append("x");
        sb.append(tileLocation.getX());
    }
}

