/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images.dto;

import java.util.Map;

public class ImageTransformationParams {
    private final boolean applyNonImageLevelTransformation;
    private final boolean useMergedChannelsTransformation;
    private final String singleChannelTransformationCodeOrNull;
    private Map<String, String> transformationsPerChannel;

    public ImageTransformationParams(boolean applyNonImageLevelTransformation, boolean useMergedChannelsTransformation, String singleChannelTransformationCodeOrNull, Map<String, String> transformationsPerChannel) {
        this.applyNonImageLevelTransformation = applyNonImageLevelTransformation;
        this.useMergedChannelsTransformation = useMergedChannelsTransformation;
        this.singleChannelTransformationCodeOrNull = singleChannelTransformationCodeOrNull;
        this.transformationsPerChannel = transformationsPerChannel;
    }

    public boolean isApplyNonImageLevelTransformation() {
        return this.applyNonImageLevelTransformation;
    }

    public boolean isUseMergedChannelsTransformation() {
        return this.useMergedChannelsTransformation;
    }

    public String tryGetSingleChannelTransformationCode() {
        return this.singleChannelTransformationCodeOrNull;
    }

    public String tryGetTransformationCodeForChannel(String channelCode) {
        if (channelCode == null || this.transformationsPerChannel == null) {
            return null;
        }
        return this.transformationsPerChannel.get(channelCode);
    }

    public Map<String, String> tryGetTransformationCodeForChannels() {
        if (this.transformationsPerChannel == null) {
            return null;
        }
        return this.transformationsPerChannel;
    }
}

