/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.demo;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class DatasetModificationReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final long serialVersionUID = 1L;

    public DatasetModificationReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        builder.addHeader("File");
        builder.addHeader("Modification date");
        for (DatasetDescription dataset : datasets) {
            File file = this.getDataSubDir(context.getDirectoryProvider(), dataset);
            String datasetCode = dataset.getDataSetCode();
            List<ISerializableComparable> row = Arrays.asList(new StringTableCell(datasetCode), new StringTableCell(new Date(file.lastModified()).toString()));
            builder.addRow(row);
        }
        return builder.getTableModel();
    }
}

