/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IProcessingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.JythonBasedPluginUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.PluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IDataSet;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JythonBasedProcessingPlugin
implements IProcessingPluginTask {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, JythonBasedProcessingPlugin.class);
    private static final String SCRIPT_PATH = "script-path";
    private final IPluginScriptRunnerFactory scriptRunnerFactory;
    transient IHierarchicalContentProvider hierarchicalContentProvider;

    protected static String getScriptPathProperty(Properties properties) {
        return PropertyUtils.getMandatoryProperty(properties, SCRIPT_PATH);
    }

    public JythonBasedProcessingPlugin(Properties properties, File storeRoot) {
        this(new PluginScriptRunnerFactory(JythonBasedProcessingPlugin.getScriptPathProperty(properties)), null);
    }

    protected JythonBasedProcessingPlugin(IPluginScriptRunnerFactory scriptRunnerFactory, IHierarchicalContentProvider contentProvider) {
        this.scriptRunnerFactory = scriptRunnerFactory;
        this.hierarchicalContentProvider = contentProvider;
    }

    private IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> dataSets, DataSetProcessingContext context) {
        operationLog.info((Object)("Processing of the following datasets has been requested: " + dataSets));
        IProcessingPluginScriptRunner scriptRunner = this.scriptRunnerFactory.createProcessingPluginRunner(context);
        IHierarchicalContentProvider contentProvider = this.getHierarchicalContentProvider();
        List<IDataSet> iDataSets = JythonBasedPluginUtils.convert(dataSets, contentProvider);
        try {
            ProcessingStatus result = new ProcessingStatus();
            for (IDataSet dataSet : iDataSets) {
                result.addDatasetStatus(dataSet.getDataSetCode(), this.delegateProcessing(scriptRunner, dataSet));
            }
            operationLog.info((Object)"Processing done.");
            ProcessingStatus processingStatus = result;
            return processingStatus;
        }
        finally {
            JythonBasedPluginUtils.closeContent(iDataSets);
            scriptRunner.releaseResources();
        }
    }

    private Status delegateProcessing(IProcessingPluginScriptRunner scriptRunner, IDataSet dataSet) {
        return scriptRunner.process(dataSet);
    }
}

