/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.ITableModelCreator;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.SimpleTableModelBuilderAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import org.apache.log4j.Logger;

class Utils {
    Utils() {
    }

    static TableModel generateTableModel(ITableModelCreator tableModelCreator, String scriptPath, Logger notifyLog) {
        try {
            SimpleTableModelBuilderAdaptor builder = SimpleTableModelBuilderAdaptor.create();
            tableModelCreator.create(builder);
            return (TableModel)builder.getTableModel();
        }
        catch (RuntimeException ex) {
            notifyLog.error((Object)Utils.createErrorMessage(scriptPath), (Throwable)ex);
            throw Utils.createUserFailureException(ex);
        }
    }

    private static String createErrorMessage(String scriptPath) {
        return "Could not run report script " + scriptPath;
    }

    private static UserFailureException createUserFailureException(RuntimeException ex) {
        return new UserFailureException("Chosen plugin failed to create a report: " + ExceptionUtils.getEndOfChain(ex), ex);
    }
}

