/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.ITableModelTransformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EntityLinksDecorator
implements ITableModelTransformation {
    private static final String LINK_COLUMNS_KEY = "link-columns";
    private static final String ENTITY_KIND_KEY = "entity-kind";
    private final Map<String, IEntityTableCellTranslation> translations = new HashMap<String, IEntityTableCellTranslation>();

    public EntityLinksDecorator(Properties properties) {
        PropertyParametersUtil.SectionProperties[] sections;
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = sections = PropertyParametersUtil.extractSectionProperties(properties, LINK_COLUMNS_KEY, false);
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties section = sectionPropertiesArray[n2];
            Properties sectionProperties = section.getProperties();
            EntityTableCellTranslationFactory factory = this.getEntityTableCellTranslationFactory(sectionProperties);
            this.translations.put(section.getKey(), factory.create(sectionProperties));
            ++n2;
        }
    }

    private EntityTableCellTranslationFactory getEntityTableCellTranslationFactory(Properties sectionProperties) {
        EntityTableCellTranslationFactory factory;
        String ek = PropertyUtils.getMandatoryProperty(sectionProperties, ENTITY_KIND_KEY);
        try {
            factory = EntityTableCellTranslationFactory.valueOf(ek);
            factory.assertValidProperties(sectionProperties);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConfigurationFailureException("Unknown entity kind: " + ek);
        }
        return factory;
    }

    @Override
    public TableModel transform(TableModel tableModel) {
        class TranslationAndIndex {
            int index;
            IEntityTableCellTranslation translation;

            TranslationAndIndex(int index, IEntityTableCellTranslation translation) {
                this.index = index;
                this.translation = translation;
            }
        }
        ArrayList<TranslationAndIndex> translationsAndIndices = new ArrayList<TranslationAndIndex>();
        List<TableModelColumnHeader> headers = tableModel.getHeader();
        int i = 0;
        while (i < headers.size()) {
            TableModelColumnHeader header = headers.get(i);
            IEntityTableCellTranslation translation = this.translations.get(header.getId());
            if (translation != null) {
                translationsAndIndices.add(new TranslationAndIndex(i, translation));
                header.setEntityKind(translation.getEntityKind());
            }
            ++i;
        }
        List<TableModelRow> rows = tableModel.getRows();
        for (TableModelRow row : rows) {
            List<ISerializableComparable> values = row.getValues();
            for (TranslationAndIndex generatorAndIndex : translationsAndIndices) {
                int index = generatorAndIndex.index;
                ISerializableComparable value = values.get(index);
                values.set(index, generatorAndIndex.translation.translation(value));
            }
        }
        return tableModel;
    }

    private static enum EntityTableCellTranslationFactory {
        MATERIAL{
            private static final String MATERIAL_TYPE_KEY = "material-type";

            @Override
            void assertValidProperties(Properties properties) {
                this.getMaterialType(properties);
            }

            @Override
            IEntityTableCellTranslation create(Properties properties) {
                final String materialType = this.getMaterialType(properties);
                return new IEntityTableCellTranslation(){

                    @Override
                    public ISerializableComparable translation(ISerializableComparable value) {
                        String materialCode = value.toString();
                        EntityTableCell entityTableCell = new EntityTableCell(EntityKind.MATERIAL, MaterialIdentifier.print(materialCode, materialType));
                        entityTableCell.setLinkText(materialCode);
                        return entityTableCell;
                    }

                    @Override
                    public EntityKind getEntityKind() {
                        return EntityKind.MATERIAL;
                    }
                };
            }

            String getMaterialType(Properties properties) {
                return PropertyUtils.getMandatoryProperty(properties, MATERIAL_TYPE_KEY).trim();
            }
        }
        ,
        SAMPLE{
            private static final String DEFAULT_SPACE_KEY = "default-space";

            @Override
            IEntityTableCellTranslation create(Properties properties) {
                String property = properties.getProperty(DEFAULT_SPACE_KEY);
                final String defaultSpace = property == null ? null : "/" + property.trim();
                return new IEntityTableCellTranslation(){

                    @Override
                    public ISerializableComparable translation(ISerializableComparable value) {
                        String identifier = SampleIdentifierFactory.parse(value.toString(), defaultSpace).toString();
                        EntityTableCell entityTableCell = new EntityTableCell(EntityKind.SAMPLE, "", identifier);
                        entityTableCell.setLinkText(value.toString());
                        return entityTableCell;
                    }

                    @Override
                    public EntityKind getEntityKind() {
                        return EntityKind.SAMPLE;
                    }
                };
            }
        };


        void assertValidProperties(Properties properties) {
        }

        abstract IEntityTableCellTranslation create(Properties var1);
    }

    private static interface IEntityTableCellTranslation {
        public ISerializableComparable translation(ISerializableComparable var1);

        public EntityKind getEntityKind();
    }
}

