/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDataMergingReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IterativeTableModelBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class MergedColumnDataReportingPlugin
extends AbstractDataMergingReportingPlugin {
    private static final long serialVersionUID = 1L;
    private static final String ROW_ID_COLUMN_HEADER = "row-id-column-header";
    private final String rowIdentifierColumnHeader;

    public MergedColumnDataReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        String rowIdColumnHeaderOrNull = properties.getProperty(ROW_ID_COLUMN_HEADER);
        this.rowIdentifierColumnHeader = rowIdColumnHeaderOrNull == null ? "id" : rowIdColumnHeaderOrNull;
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        IterativeTableModelBuilder builder = new IterativeTableModelBuilder(this.rowIdentifierColumnHeader);
        for (DatasetDescription dataset : datasets) {
            File dir = this.getDataSubDir(context.getDirectoryProvider(), dataset);
            DatasetFileLines lines = this.loadFromDirectory(dataset, dir);
            builder.addFile(lines);
        }
        return builder.getTableModel();
    }
}

