/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public abstract class ArchiveFolders {
    public abstract File getFolder(DatasetDescription var1);

    public abstract Collection<File> getAllFolders();

    public static ArchiveFolders create(File[] folders, boolean createFolders, Long smallDataSetsSizeLimit) {
        String[] folderPaths = new String[folders.length];
        int i = 0;
        while (i < folders.length) {
            File folder = folders[i];
            if (folder != null) {
                folderPaths[i] = folder.getPath();
            }
            ++i;
        }
        return ArchiveFolders.create(folderPaths, createFolders, smallDataSetsSizeLimit);
    }

    public static ArchiveFolders create(String[] folderPaths, boolean createFolders, Long smallDataSetsSizeLimit) {
        ArrayList<String> notBlankPaths = new ArrayList<String>();
        String[] stringArray = folderPaths;
        int n = folderPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String folderPath = stringArray[n2];
            if (!StringUtils.isBlank((String)folderPath)) {
                notBlankPaths.add(folderPath.trim());
            }
            ++n2;
        }
        if (notBlankPaths.isEmpty()) {
            return null;
        }
        if (notBlankPaths.size() == 1) {
            return new CommonArchiveFolder((String)notBlankPaths.get(0), createFolders);
        }
        if (notBlankPaths.size() == 2) {
            return new SizeDependentArchiveFolders((String)notBlankPaths.get(0), (String)notBlankPaths.get(1), createFolders, smallDataSetsSizeLimit);
        }
        throw new IllegalArgumentException("Found " + notBlankPaths.size() + " archive folders: " + notBlankPaths + ". Please specify only one folder for all sizes of data sets or two separate folders for big and small data sets respectively.");
    }

    protected File prepareFolder(String folderPath, boolean createFolder) {
        File folder = new File(folderPath);
        if (createFolder) {
            boolean success;
            if (folder.isFile()) {
                throw new IllegalArgumentException("Archive folder '" + folder + "' is a file.");
            }
            if (!folder.exists() && !(success = folder.mkdirs())) {
                throw new IllegalArgumentException("Couldn't create archive folder '" + folder + "'.");
            }
        } else if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Archive folder '" + folder + "' doesn't exists or is a file.");
        }
        return folder;
    }

    static class CommonArchiveFolder
    extends ArchiveFolders {
        private File dataSetsFolder;

        private CommonArchiveFolder(String folderPath, boolean createFolder) {
            this.dataSetsFolder = this.prepareFolder(folderPath, createFolder);
        }

        @Override
        public File getFolder(DatasetDescription dataSetDescription) {
            return this.dataSetsFolder;
        }

        @Override
        public Collection<File> getAllFolders() {
            return Arrays.asList(this.dataSetsFolder);
        }
    }

    static class SizeDependentArchiveFolders
    extends ArchiveFolders {
        private File bigDataSetsFolder;
        private File smallDataSetsFolder;
        private Long smallDataSetsSizeLimit;
        private IEncapsulatedOpenBISService service;
        private IShareIdManager shareIdManager;
        private IConfigProvider configProvider;

        private SizeDependentArchiveFolders(String bigDataSetsFolderPath, String smallDataSetsFolderPath, boolean createFolders, Long smallDataSetsSizeLimit) {
            if (smallDataSetsSizeLimit == null) {
                throw new IllegalArgumentException("Small data set size limit cannot be null");
            }
            this.bigDataSetsFolder = this.prepareFolder(bigDataSetsFolderPath, createFolders);
            this.smallDataSetsFolder = this.prepareFolder(smallDataSetsFolderPath, createFolders);
            this.smallDataSetsSizeLimit = smallDataSetsSizeLimit;
        }

        @Override
        public File getFolder(DatasetDescription dataSetDescription) {
            if (dataSetDescription.getDataSetSize() == null) {
                String shareId = this.getShareIdManager().getShareId(dataSetDescription.getDataSetCode());
                File shareFolder = new File(this.getConfigProvider().getStoreRoot(), shareId);
                long size = FileUtils.sizeOfDirectory((File)new File(shareFolder, dataSetDescription.getDataSetLocation()));
                this.getService().updateShareIdAndSize(dataSetDescription.getDataSetCode(), shareId, size);
                dataSetDescription.setDataSetSize(size);
            }
            if (dataSetDescription.getDataSetSize() > this.smallDataSetsSizeLimit) {
                return this.bigDataSetsFolder;
            }
            return this.smallDataSetsFolder;
        }

        @Override
        public Collection<File> getAllFolders() {
            return Arrays.asList(this.bigDataSetsFolder, this.smallDataSetsFolder);
        }

        private IConfigProvider getConfigProvider() {
            if (this.configProvider == null) {
                this.configProvider = ServiceProvider.getConfigProvider();
            }
            return this.configProvider;
        }

        private IShareIdManager getShareIdManager() {
            if (this.shareIdManager == null) {
                this.shareIdManager = ServiceProvider.getShareIdManager();
            }
            return this.shareIdManager;
        }

        private IEncapsulatedOpenBISService getService() {
            if (this.service == null) {
                this.service = ServiceProvider.getOpenBISService();
            }
            return this.service;
        }
    }
}

