/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.resource.Resources;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSourceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import java.util.Map;
import javax.sql.DataSource;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class DataSourceQueryService
implements IDataSourceQueryService,
IReleasable {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSourceQueryService.class);
    private Resources resources = new Resources();

    private IDataSourceProvider getDataSourceProvider() {
        return ServiceProvider.getDataSourceProvider();
    }

    @Override
    public DataSet<Map<String, Object>> select(String dataSourceName, String query, Object ... parameters) {
        DataSource dataSource = this.getDataSourceProvider().getDataSource(dataSourceName);
        try {
            DataSet dataSet = QueryTool.select((DataSource)dataSource, (String)query, (Object[])parameters);
            if (dataSet != null) {
                this.resources.add(new DataSetResource(dataSet));
            }
            return dataSet;
        }
        catch (InvalidQueryException ex) {
            Throwable cause = ex.getCause();
            operationLog.error((Object)(cause == null ? ex.getMessage() : cause.getMessage()));
            throw ex;
        }
    }

    @Override
    public DataSet<Map<String, Object>> select(String dataSourceName, String query) throws IllegalArgumentException {
        return this.select(dataSourceName, query, new Object[0]);
    }

    @Override
    public void release() {
        this.resources.release();
    }

    private static class DataSetResource
    implements IReleasable {
        private DataSet<?> dataSet;

        public DataSetResource(DataSet<?> dataSet) {
            this.dataSet = dataSet;
        }

        @Override
        public void release() {
            this.dataSet.close();
        }
    }
}

