/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.SpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class StandardShareFinder
implements IShareFinder {
    @Private
    public static final String MINIMUM_FREE_SPACE_KEY = "incoming-shares-minimum-free-space-in-MB";
    private final long incomingShareMinFreeSpace;

    public StandardShareFinder(Properties properties) {
        this.incomingShareMinFreeSpace = 0x100000L * PropertyUtils.getLong(properties, MINIMUM_FREE_SPACE_KEY, 1024L);
    }

    @Override
    public Share tryToFindShare(SimpleDataSetInformationDTO dataSet, List<Share> shares) {
        CandidateShare bestCandidate;
        Share bestDestinationShare;
        ArrayList<CandidateShare> candidates = new ArrayList<CandidateShare>();
        Share homeShare = this.findDataSetShare(dataSet, shares);
        for (Share share : shares) {
            if (share.isWithdrawShare() || !share.equals(homeShare) && !this.canMoveShareTo(dataSet, share)) continue;
            CandidateShare candidate = this.createCandidate(dataSet, homeShare, share);
            candidates.add(candidate);
        }
        if (!candidates.isEmpty() && !(bestDestinationShare = (bestCandidate = (CandidateShare)Collections.min(candidates)).getShare()).equals(homeShare)) {
            return bestDestinationShare;
        }
        return null;
    }

    private Share findDataSetShare(SimpleDataSetInformationDTO dataSet, List<Share> shares) {
        for (Share share : shares) {
            if (!this.isSameShare(dataSet, share)) continue;
            return share;
        }
        return null;
    }

    private boolean isSameShare(SimpleDataSetInformationDTO dataSet, Share share) {
        String dataSetShareId = dataSet.getDataSetShareId();
        return dataSetShareId != null && dataSetShareId.equals(share.getShareId());
    }

    private boolean canMoveShareTo(SimpleDataSetInformationDTO dataSet, Share share) {
        long freeSpace = share.calculateFreeSpace();
        if (share.isIncoming()) {
            freeSpace -= this.incomingShareMinFreeSpace;
        }
        boolean hasEnoughSpace = freeSpace > dataSet.getDataSetSize();
        return hasEnoughSpace;
    }

    private CandidateShare createCandidate(SimpleDataSetInformationDTO dataSet, Share homeShareOrNull, Share share) {
        long freeSpace = share.calculateFreeSpace();
        if (this.isSameShare(dataSet, share)) {
            freeSpace += dataSet.getDataSetSize().longValue();
        }
        int speedMatchRating = Integer.MAX_VALUE;
        SpeedChecker[] speedCheckerArray = SpeedChecker.values();
        int n = speedCheckerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpeedChecker speedChecker = speedCheckerArray[n2];
            if (speedChecker.check(dataSet, share)) {
                speedMatchRating = speedChecker.ordinal();
                break;
            }
            ++n2;
        }
        int speedDeviation = Math.abs(dataSet.getSpeedHint()) - share.getSpeed();
        speedDeviation = Math.abs(speedDeviation);
        return new CandidateShare(homeShareOrNull, share, speedMatchRating, speedDeviation, freeSpace);
    }

    private static class CandidateShare
    implements Comparable<CandidateShare> {
        private final Share homeShareOrNull;
        private final Share share;
        private final int speedMatchRating;
        private final int speedDeviation;
        private final long freeSpace;

        public CandidateShare(Share homeShareOrNull, Share share, int speedMatchRating, int speedDeviation, long freeSpace) {
            this.homeShareOrNull = homeShareOrNull;
            this.share = share;
            this.speedMatchRating = speedMatchRating;
            this.speedDeviation = speedDeviation;
            this.freeSpace = freeSpace;
        }

        @Override
        public int compareTo(CandidateShare otherCandidate) {
            int lessImportantCriteria;
            int moreImportantCriteria;
            int incomingToExtensionComparison = this.compareIncomingToExtension(otherCandidate);
            int speedComparison = this.compareSpeeds(otherCandidate);
            if (this.homeShareOrNull != null && this.homeShareOrNull.isIncoming() && this.homeShareOrNull.getShufflePriority() == Share.ShufflePriority.SPEED) {
                moreImportantCriteria = speedComparison;
                lessImportantCriteria = incomingToExtensionComparison;
            } else {
                moreImportantCriteria = incomingToExtensionComparison;
                lessImportantCriteria = speedComparison;
            }
            if (moreImportantCriteria != 0) {
                return moreImportantCriteria;
            }
            if (lessImportantCriteria != 0) {
                return lessImportantCriteria;
            }
            return this.compareFreeSpace(otherCandidate);
        }

        private int compareFreeSpace(CandidateShare otherCandidate) {
            long freeSpaceDiff = this.freeSpace - otherCandidate.freeSpace;
            if (freeSpaceDiff != 0L) {
                return freeSpaceDiff > 0L ? -1 : 1;
            }
            return 0;
        }

        private int compareIncomingToExtension(CandidateShare otherCandidate) {
            if (this.share.isIncoming() != otherCandidate.share.isIncoming()) {
                return this.share.isIncoming() ? 1 : -1;
            }
            return 0;
        }

        private int compareSpeeds(CandidateShare otherCandidate) {
            int speedMatchRatingDiff = this.speedMatchRating - otherCandidate.speedMatchRating;
            if (speedMatchRatingDiff == 0) {
                int speedDeviationDiff = this.speedDeviation - otherCandidate.speedDeviation;
                if (speedDeviationDiff != 0) {
                    return speedDeviationDiff;
                }
            } else {
                return speedMatchRatingDiff;
            }
            return 0;
        }

        public Share getShare() {
            return this.share;
        }
    }
}

