/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="NewDataSetDTO")
public class NewDataSetDTO
implements Serializable {
    public static String DEFAULT_DATA_SET_FOLDER_NAME = "original";
    private static final long serialVersionUID = 1L;
    private final DataSetOwner dataSetOwner;
    private final String dataSetFolderName;
    private final List<FileInfoDssDTO> fileInfos;
    private final NewDataSetMetadataDTO dataSetMetadata;

    private static String getFolderNameOrNull(File dataSetFile) {
        String folderNameOrNull = null;
        if (dataSetFile.isDirectory()) {
            folderNameOrNull = dataSetFile.getName();
        }
        return folderNameOrNull;
    }

    public NewDataSetDTO(DataSetOwner dataSetOwner, File dataSetFile) {
        this(dataSetOwner, NewDataSetDTO.getFolderNameOrNull(dataSetFile), FileInfoDssBuilder.getFileInfos(dataSetFile));
    }

    public NewDataSetDTO(DataSetOwner dataSetOwner, String dataSetFolderNameOrNull, List<FileInfoDssDTO> fileInfos) {
        this(new NewDataSetMetadataDTO(), dataSetOwner, dataSetFolderNameOrNull, fileInfos);
    }

    public NewDataSetDTO(String dataSetType, DataSetOwner dataSetOwner, String dataSetFolderNameOrNull, List<FileInfoDssDTO> fileInfos) {
        this(dataSetOwner, dataSetFolderNameOrNull, fileInfos);
        this.setDataSetTypeOrNull(dataSetType);
    }

    public NewDataSetDTO(NewDataSetMetadataDTO dataSetMetadata, DataSetOwner dataSetOwner, String dataSetFolderNameOrNull, List<FileInfoDssDTO> fileInfos) {
        this.dataSetMetadata = dataSetMetadata;
        this.dataSetOwner = dataSetOwner;
        this.dataSetFolderName = dataSetFolderNameOrNull == null ? DEFAULT_DATA_SET_FOLDER_NAME : dataSetFolderNameOrNull;
        this.fileInfos = fileInfos;
    }

    public DataSetOwner getDataSetOwner() {
        return this.dataSetOwner;
    }

    public String getDataSetFolderName() {
        return this.dataSetFolderName;
    }

    public List<FileInfoDssDTO> getFileInfos() {
        return this.fileInfos;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        sb.append((Object)this.dataSetMetadata);
        sb.append((Object)this.getDataSetOwner());
        sb.append(this.getFileInfos());
        return sb.toString();
    }

    public String tryDataSetType() {
        return this.dataSetMetadata.tryDataSetType();
    }

    public void setDataSetTypeOrNull(String dataSetTypeOrNull) {
        this.dataSetMetadata.setDataSetTypeOrNull(dataSetTypeOrNull);
    }

    public Map<String, String> getProperties() {
        return this.dataSetMetadata.getProperties();
    }

    public void setProperties(Map<String, String> props) {
        this.dataSetMetadata.setProperties(props);
    }

    public List<String> getParentDataSetCodes() {
        return this.dataSetMetadata.getParentDataSetCodes();
    }

    public void setParentDataSetCodes(List<String> codesOrNull) {
        this.dataSetMetadata.setParentDataSetCodes(codesOrNull);
    }

    @JsonObject(value="DataSetOwner")
    public static class DataSetOwner
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DataSetOwnerType type;
        private final String identifier;

        public DataSetOwner(DataSetOwnerType type, String identifier) {
            this.type = type;
            this.identifier = identifier;
        }

        public DataSetOwnerType getType() {
            return this.type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
            sb.append((Object)this.getType());
            sb.append((Object)this.getIdentifier());
            return sb.toString();
        }
    }

    @JsonObject(value="DataSetOwnerType")
    public static enum DataSetOwnerType {
        EXPERIMENT{

            @Override
            public String toString() {
                return "Experiment";
            }
        }
        ,
        SAMPLE{

            @Override
            public String toString() {
                return "Sample";
            }
        }
        ,
        DATA_SET{

            @Override
            public String toString() {
                return "Data Set";
            }
        };


        public abstract String toString();
    }
}

