/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ValidationScriptReader {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ValidationScriptReader.class);

    public static String tryReadValidationScript(String[] scriptPaths) {
        if (scriptPaths == null) {
            return null;
        }
        StringBuilder concatenatedScripts = new StringBuilder();
        String[] stringArray = scriptPaths;
        int n = scriptPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String scriptPath = stringArray[n2];
            File scriptFile = new File(scriptPath);
            if (!scriptFile.exists()) {
                operationLog.warn((Object)("Invalid validation script [" + scriptPath + "] specified in the configuration."));
            } else {
                concatenatedScripts.append(FileUtilities.loadToString(scriptFile)).append("\n");
            }
            ++n2;
        }
        String concatenated = concatenatedScripts.toString();
        if (StringUtils.isBlank((String)concatenated)) {
            return "";
        }
        return ValidationScriptReader.insertStandardImportClauses(concatenated);
    }

    private static String insertStandardImportClauses(String scriptString) {
        String standardImports = "from " + ValidationError.class.getCanonicalName() + " import *";
        return String.valueOf(standardImports) + "\n" + scriptString;
    }
}

