/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.cli;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import java.io.IOException;
import java.util.List;
import jline.ConsoleReader;

public class DataSetLister {
    private final IGeneralInformationService generalInformationService;
    private final String sessionToken;

    public static void main(String[] args) throws Exception {
        String serverUrl = args[0];
        String userId = args[1];
        String password = args.length == 3 ? args[2] : DataSetLister.getConsoleReader().readLine("Password: ", Character.valueOf('*'));
        ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-v1");
        IGeneralInformationService service = generalInformationServiceFinder.createService(IGeneralInformationService.class, serverUrl);
        String sessionToken = service.tryToAuthenticateForAllServices(userId, password);
        DataSetLister me = new DataSetLister(service, sessionToken);
        me.findDataSetsForSamplesWithProperty("DESCRIPTION", "*");
    }

    private static ConsoleReader getConsoleReader() {
        try {
            return new ConsoleReader();
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("ConsoleReader could not be instantiated.", ex);
        }
    }

    public DataSetLister(IGeneralInformationService generalInformationService, String sessionToken) {
        this.generalInformationService = generalInformationService;
        this.sessionToken = sessionToken;
    }

    private void findAllDataSets() {
        SearchCriteria sc = new SearchCriteria();
        sc.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, "*"));
        List<Sample> samples = this.generalInformationService.searchForSamples(this.sessionToken, sc);
        List<DataSet> result = this.generalInformationService.listDataSets(this.sessionToken, samples);
        System.out.println("Number of data sets:\n" + result.size());
        System.out.println("\n");
    }

    private void findDataSetsForSamplesWithProperty(String property, String desiredValue) {
        SearchCriteria sc = new SearchCriteria();
        sc.addMatchClause(SearchCriteria.MatchClause.createPropertyMatch(property, desiredValue));
        List<Sample> samples = this.generalInformationService.searchForSamples(this.sessionToken, sc);
        List<DataSet> result = this.generalInformationService.listDataSets(this.sessionToken, samples);
        StringBuilder sb = new StringBuilder();
        sb.append("Found ");
        sb.append(samples.size());
        sb.append(" sample(s) with ");
        sb.append(property);
        sb.append("=");
        sb.append(desiredValue);
        sb.append(". Data sets attached to these samples:\n");
        sb.append(result);
        System.out.println(sb.toString());
        System.out.println("\n");
    }

    private void findDataSetsForSamplesWithCode(String code) {
        SearchCriteria sc = new SearchCriteria();
        sc.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, code));
        List<Sample> samples = this.generalInformationService.searchForSamples(this.sessionToken, sc);
        List<DataSet> result = this.generalInformationService.listDataSets(this.sessionToken, samples);
        StringBuilder sb = new StringBuilder();
        sb.append("Found ");
        sb.append(samples.size());
        sb.append(" sample(s) with code");
        sb.append("=");
        sb.append(code);
        sb.append(". Data sets attached to these samples:\n");
        sb.append(result);
        System.out.println(sb.toString());
        System.out.println("\n");
    }
}

