/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import ch.systemsx.cisd.openbis.generic.client.console.AttributeSetter;
import ch.systemsx.cisd.openbis.generic.client.console.ICommand;
import ch.systemsx.cisd.openbis.generic.client.console.Lexer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import java.util.List;
import java.util.Map;

public abstract class AbstractRegisterEntityType<T extends EntityType>
implements ICommand {
    protected abstract Map<String, AttributeSetter<T>> attributeSetters();

    private void fillWithDefaults(T entityType) {
        for (AttributeSetter<T> setter : this.attributeSetters().values()) {
            setter.setDefaultFor(entityType);
        }
    }

    protected T prepareEntityType(T entityType, String argument) {
        List<String> tokens = Lexer.extractTokens(argument);
        ((Code)entityType).setCode(tokens.get(0));
        this.fillWithDefaults(entityType);
        int i = 1;
        while (i < tokens.size()) {
            String token = tokens.get(i);
            int indexOfEqualSign = token.indexOf(61);
            if (indexOfEqualSign < 0) {
                throw new IllegalArgumentException("Missing '=': " + token);
            }
            String key = token.substring(0, indexOfEqualSign);
            String value = token.substring(indexOfEqualSign + 1);
            AttributeSetter<T> attributeSetter = this.attributeSetters().get(key);
            if (attributeSetter == null) {
                throw new IllegalArgumentException("Unknown attribute '" + key + "': " + token);
            }
            attributeSetter.setAttributeFor(entityType, value);
            ++i;
        }
        return entityType;
    }
}

