/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import ch.systemsx.cisd.openbis.generic.client.console.AbstractRegisterEntityType;
import ch.systemsx.cisd.openbis.generic.client.console.AttributeSetter;
import ch.systemsx.cisd.openbis.generic.client.console.ICommand;
import ch.systemsx.cisd.openbis.generic.client.console.ScriptContext;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import java.util.HashMap;
import java.util.Map;

public class RegisterMaterialType
extends AbstractRegisterEntityType<MaterialType>
implements ICommand {
    private static final Map<String, AttributeSetter<MaterialType>> attributeSetters = new HashMap<String, AttributeSetter<MaterialType>>();

    static {
        MaterialTypeAttributeSetter[] materialTypeAttributeSetterArray = MaterialTypeAttributeSetter.values();
        int n = materialTypeAttributeSetterArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaterialTypeAttributeSetter setter = materialTypeAttributeSetterArray[n2];
            attributeSetters.put(setter.getAttributeName(), setter);
            ++n2;
        }
    }

    @Override
    protected Map<String, AttributeSetter<MaterialType>> attributeSetters() {
        return attributeSetters;
    }

    @Override
    public void execute(ICommonServer server, String sessionToken, ScriptContext context, String argument) {
        server.registerMaterialType(sessionToken, this.prepareEntityType(new MaterialType(), argument));
    }

    private static enum MaterialTypeAttributeSetter implements AttributeSetter<MaterialType>
    {
        DESCRIPTION("description"){

            @Override
            public void setAttributeFor(MaterialType materialType, String value) {
                materialType.setDescription(value);
            }
        };

        private final String attributeName;

        private MaterialTypeAttributeSetter(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public void setDefaultFor(MaterialType type) {
        }
    }
}

