/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ShowResultSetCutInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.core.XDOM;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.Arrays;
import java.util.List;

public final class MatchingEntitiesPanel
extends TypedTableGrid<MatchingEntity> {
    static final String PREFIX = "openbis_matching-entities-panel_";
    static final String GRID_ID = "openbis_matching-entities-panel_grid";
    public static final String SHOW_RELATED_DATASETS_BUTTON_ID = "openbis_matching-entities-panel_grid_show-related-datasets-button";
    private final SearchableEntity searchableEntity;
    private final String queryText;
    private final boolean useWildcardSearchMode;

    public IDisposableComponent asDisposableComponent() {
        return this.asDisposableWithoutToolbar();
    }

    public MatchingEntitiesPanel(IViewContext<ICommonClientServiceAsync> viewContext, SearchableEntity searchableEntity, String queryText, boolean useWildcardSearchMode) {
        super(viewContext, GRID_ID, false, DisplayTypeIDGenerator.SEARCH_RESULT_GRID);
        this.searchableEntity = searchableEntity;
        this.queryText = queryText;
        this.useWildcardSearchMode = useWildcardSearchMode;
        this.setId(MatchingEntitiesPanel.createId());
        this.updateDefaultRefreshButton();
        ICellListenerAndLinkGenerator<MatchingEntity> listenerLinkGenerator = new ICellListenerAndLinkGenerator<MatchingEntity>(){

            @Override
            public void handle(TableModelRowWithObject<MatchingEntity> rowItem, boolean specialKeyPressed) {
                MatchingEntitiesPanel.this.showEntityViewer(rowItem, false, specialKeyPressed);
            }

            @Override
            public String tryGetLink(MatchingEntity entity, ISerializableComparable comparableValue) {
                return LinkExtractor.tryExtract(entity);
            }
        };
        this.registerListenerAndLinkGenerator("IDENTIFIER", listenerLinkGenerator);
        this.extendBottomToolbar();
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        String showRelatedDatasetsTitle = this.viewContext.getMessage("show_related_datasets", new Object[0]);
        Button showRelatedDatasetsButton = new Button(showRelatedDatasetsTitle, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                MatchingEntitiesPanel.showRelatedDataSets(MatchingEntitiesPanel.this.viewContext, MatchingEntitiesPanel.this);
            }
        });
        showRelatedDatasetsButton.setId(SHOW_RELATED_DATASETS_BUTTON_ID);
        this.addButton(showRelatedDatasetsButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    private static String createId() {
        return PREFIX + XDOM.getUniqueId();
    }

    @Override
    protected boolean isRefreshEnabled() {
        return true;
    }

    @Override
    protected final void refresh() {
        super.refresh(false);
    }

    @Override
    public final void refresh(IDataRefreshCallback newRefreshCallback) {
        super.refresh(newRefreshCallback, true);
    }

    @Override
    protected void showEntityViewer(TableModelRowWithObject<MatchingEntity> object, boolean editMode, boolean inBackground) {
        MatchingEntity matchingEntity = object.getObjectOrNull();
        EntityKind entityKind = matchingEntity.getEntityKind();
        BasicEntityType entityType = matchingEntity.getEntityType();
        IClientPluginFactory clientPluginFactory = this.viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, entityType);
        IClientPlugin clientPlugin = clientPluginFactory.createClientPlugin(entityKind);
        AbstractTabItemFactory tabView = clientPlugin.createEntityViewer(matchingEntity.asIdentifiable());
        tabView.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabView);
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<MatchingEntity>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<MatchingEntity>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        schema.setGridCellRendererFor("IDENTIFIER", this.createInternalLinkCellRenderer());
        return schema;
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<MatchingEntity>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<MatchingEntity>> callback) {
        ShowResultSetCutInfo info = new ShowResultSetCutInfo(this.viewContext);
        callback.addOnSuccessAction(info);
        ((ICommonClientServiceAsync)this.viewContext.getService()).listMatchingEntities(this.searchableEntity, this.queryText, this.useWildcardSearchMode, resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<MatchingEntity>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportMatchingEntities(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("ENTITY_TYPE", "IDENTIFIER", "MATCHING_FIELD");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.MATERIAL), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.MATERIAL), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM)};
    }
}

