/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PropertyValueRenderers;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.PropertyGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.MultilineHTML;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProjectPropertiesPanel
extends ContentPanel {
    public static final String PROPERTIES_ID_PREFIX = "openbis_project-properties-section_";
    private final Project project;
    private final IViewContext<?> viewContext;

    public ProjectPropertiesPanel(Project project, IViewContext<?> viewContext) {
        this.setHeading("Project Properties");
        this.project = project;
        this.viewContext = viewContext;
        PropertyGrid propertyGrid = this.createPropertyGrid();
        this.add((Widget)propertyGrid);
    }

    private final PropertyGrid createPropertyGrid() {
        Map<String, Object> properties = this.createProperties(this.viewContext);
        PropertyGrid propertyGrid = new PropertyGrid(this.viewContext, properties.size());
        propertyGrid.getElement().setId(PROPERTIES_ID_PREFIX + this.project.getIdentifier());
        propertyGrid.registerPropertyValueRenderer(Person.class, PropertyValueRenderers.createPersonPropertyValueRenderer(this.viewContext));
        propertyGrid.setProperties(properties);
        return propertyGrid;
    }

    private final Map<String, Object> createProperties(IMessageProvider messageProvider) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put(messageProvider.getMessage("project", new Object[0]), this.project.getIdentifier());
        properties.put(messageProvider.getMessage("perm_id", new Object[0]), this.project.getPermId());
        properties.put(messageProvider.getMessage("registrator", new Object[0]), this.project.getRegistrator());
        properties.put(messageProvider.getMessage("registration_date", new Object[0]), this.project.getRegistrationDate());
        String description = this.project.getDescription() == null ? null : new MultilineHTML(this.project.getDescription()).toString();
        properties.put(messageProvider.getMessage("description", new Object[0]), description);
        return properties;
    }
}

